"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRedirectToOnboardingStart = void 0;
var _react = require("react");
var _kea = require("kea");
var _lib = require("react-use/lib");
var _deeplinksSearch = require("@kbn/deeplinks-search");
var _public = require("@kbn/kibana-react-plugin/public");
var _api = require("../../../../common/types/api");
var _fetch_indices_status = require("../api/fetch_indices_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRedirectToOnboardingStart = () => {
  const {
    services: {
      application,
      searchIndices,
      navigation
    }
  } = (0, _public.useKibana)();
  const {
    makeRequest
  } = (0, _kea.useActions)(_fetch_indices_status.FetchIndicesStatusAPILogic);
  const {
    data: indicesStatus,
    status
  } = (0, _kea.useValues)(_fetch_indices_status.FetchIndicesStatusAPILogic);
  const isLoading = status === _api.Status.LOADING;
  const isSolutionNav = (0, _lib.useObservable)(navigation.isSolutionNavEnabled$, false);
  (0, _react.useEffect)(() => {
    if (searchIndices !== null && searchIndices !== void 0 && searchIndices.enabled && isSolutionNav) {
      makeRequest({});
    }
  }, [isSolutionNav, searchIndices]);
  (0, _react.useEffect)(() => {
    if (!isLoading && isSolutionNav && (indicesStatus === null || indicesStatus === void 0 ? void 0 : indicesStatus.indexNames.length) === 0) {
      application === null || application === void 0 ? void 0 : application.navigateToApp(_deeplinksSearch.SEARCH_INDICES_START);
    }
  }, [isLoading, application, indicesStatus, isSolutionNav]);
  return {
    isChecking: isLoading
  };
};
exports.useRedirectToOnboardingStart = useRedirectToOnboardingStart;