"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WelcomeBanner = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WelcomeBanner = ({
  user,
  image
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xxl"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 2
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "flexStart",
  direction: "columnReverse",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "l"
}, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.welcomeBanner.header.title",
  defaultMessage: "Add data to Elasticsearch and then search, vectorize, or visualize"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued"
}, _i18n.i18n.translate('xpack.enterpriseSearch.welcomeBanner.header.titleDescription', {
  defaultMessage: 'There are endless ways to ingest and explore data with Elasticsearch, connect to your Elasticsearch instance and start indexing data'
}))), Boolean(user) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued"
}, /*#__PURE__*/_react.default.createElement("h4", null, user ? _i18n.i18n.translate('xpack.enterpriseSearch.welcomeBanner.header.greeting.customTitle', {
  defaultMessage: '👋 Hi {name}!',
  values: {
    name: user.full_name || user.username
  }
}) : _i18n.i18n.translate('xpack.enterpriseSearch.welcomeBanner.header.greeting.defaultTitle', {
  defaultMessage: '👋 Hi'
})))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 1
}, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
  alt: "",
  src: image,
  size: "original"
}))));
exports.WelcomeBanner = WelcomeBanner;