"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelfManagedWebCrawlerEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchSharedUi = require("@kbn/search-shared-ui");
var _github_icon = require("../../../shared/icons/github_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelfManagedWebCrawlerEmptyPrompt = () => {
  return /*#__PURE__*/_react.default.createElement(_searchSharedUi.SearchEmptyPrompt, {
    icon: "web",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.webCrawlersEmpty.title', {
      defaultMessage: 'Set up a web crawler'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.webCrawlersEmpty.description', {
      defaultMessage: "To set up and deploy a web crawler you'll be working between data source, your terminal, and the Kibana UI. The high level process looks like this:"
    }),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "stretch",
      justifyContent: "center",
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_searchSharedUi.DecorativeHorizontalStepper, {
      stepCount: 3
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      direction: "row",
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "web"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "sortRight"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "launch"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.webCrawlersEmpty.guideTwoDescription",
      defaultMessage: "Deploy web crawler code on your own infrastructure by running from {source}, or using {docker}",
      values: {
        source: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          "data-test-subj": "enterpriseSearchEmptyConnectorsPromptSourceLink",
          href: 'https://github.com/elastic/crawler'
        }, _i18n.i18n.translate('xpack.enterpriseSearch.webCrawlersEmpty.sourceLabel', {
          defaultMessage: 'source'
        })),
        docker: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          "data-test-subj": "enterpriseSearchEmptyConnectorsPromptDockerLink",
          href: 'https://github.com/elastic/crawler?tab=readme-ov-file#running-open-crawler-with-docker'
        }, _i18n.i18n.translate('xpack.enterpriseSearch.webCrawlersEmpty.dockerLabel', {
          defaultMessage: 'Docker'
        }))
      }
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      direction: "row",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "globe"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.webCrawlersEmpty.guideOneDescription', {
      defaultMessage: 'Set one or more domain URLs you want to crawl'
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      direction: "row",
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "globe"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "sortRight"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "web"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "sortRight"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "l",
      type: "logoElasticsearch"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.webCrawlersEmpty.guideThreeDescription', {
      defaultMessage: 'Configure your web crawler and connect it to Elasticsearch'
    })))))))))),
    actions: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "enterpriseSearchEmptyConnectorsPromptCreateSelfManagedConnectorButton",
      fill: true,
      iconType: _github_icon.GithubIcon,
      href: 'https://github.com/elastic/crawler',
      target: "_blank"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.webCrawlersEmpty.selfManagedButton', {
      defaultMessage: 'Self-managed web crawler'
    }))))
  });
};
exports.SelfManagedWebCrawlerEmptyPrompt = SelfManagedWebCrawlerEmptyPrompt;