"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteIndex = exports.DeleteIndexApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteIndex = async ({
  indexName
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}`;
  await _http.HttpLogic.values.http.delete(route);
  return {
    indexName
  };
};
exports.deleteIndex = deleteIndex;
const DeleteIndexApiLogic = exports.DeleteIndexApiLogic = (0, _create_api_logic.createApiLogic)(['delete_index_api_logic'], deleteIndex, {
  showSuccessFlashFn: ({
    indexName
  }) => _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.deleteIndex.successToast.title', {
    defaultMessage: 'Your index {indexName} and any associated ingestion configurations were successfully deleted',
    values: {
      indexName
    }
  })
});