"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionCardStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsCollectionCardStyles = euiTheme => ({
  badge: {
    '.euiBadge__text': {
      color: euiTheme.colors.mediumShade
    },
    color: euiTheme.colors.subduedText,
    cursor: 'inherit'
  },
  card: {
    '& .euiCard__titleAnchor': {
      alignItems: 'start',
      display: 'flex',
      gap: euiTheme.size.s,
      justifyContent: 'space-between'
    },
    '&:hover': {
      '&__text': {
        color: euiTheme.colors.subduedText
      },
      '.euiBadge': {
        color: euiTheme.colors.text
      },
      '.euiCard__titleAnchor': {
        textDecoration: 'none !important'
      }
    },
    height: 200,
    overflow: 'hidden',
    position: 'relative',
    width: '100%'
  },
  chart: {
    '.euiPanel:hover &': {
      transform: 'scale(1.03)'
    },
    bottom: 0,
    left: 0,
    position: 'absolute !important',
    right: 0,
    transition: `transform ${euiTheme.animation.normal}`
  },
  footer: {
    position: 'relative',
    zIndex: 1
  },
  subtitle: {
    fontWeight: euiTheme.font.weight.light,
    position: 'relative',
    zIndex: 1
  },
  title: (0, _react.css)`
    ${(0, _eui.euiTextTruncate)()}
  `
});
exports.AnalyticsCollectionCardStyles = AnalyticsCollectionCardStyles;