"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.appContextService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Service for managing context specific to the Elastic Assistant
 *
 * Inspired by `AppContextService` impl from fleet plugin: x-pack/platform/plugins/shared/fleet/server/services/app_context.ts
 */
class AppContextService {
  constructor() {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "registeredTools", new Map());
    (0, _defineProperty2.default)(this, "registeredFeatures", new Map());
  }
  start(appContext) {
    this.logger = appContext.logger;
  }
  stop() {
    this.registeredTools.clear();
    this.registeredFeatures.clear();
  }

  /**
   * Register tools to be used by the Elastic Assistant
   *
   * @param pluginName
   * @param tools
   */
  registerTools(pluginName, tools) {
    var _this$logger, _this$logger2, _this$logger3;
    (_this$logger = this.logger) === null || _this$logger === void 0 ? void 0 : _this$logger.debug('AppContextService:registerTools');
    (_this$logger2 = this.logger) === null || _this$logger2 === void 0 ? void 0 : _this$logger2.debug(`pluginName: ${pluginName}`);
    (_this$logger3 = this.logger) === null || _this$logger3 === void 0 ? void 0 : _this$logger3.debug(`tools: ${tools.map(tool => tool.name).join(', ')}`);
    if (!this.registeredTools.has(pluginName)) {
      var _this$logger4;
      (_this$logger4 = this.logger) === null || _this$logger4 === void 0 ? void 0 : _this$logger4.debug('plugin has no tools, initializing...');
      this.registeredTools.set(pluginName, new Set());
    }
    tools.forEach(tool => {
      var _this$registeredTools;
      return (_this$registeredTools = this.registeredTools.get(pluginName)) === null || _this$registeredTools === void 0 ? void 0 : _this$registeredTools.add(tool);
    });
  }

  /**
   * Get the registered tools
   *
   * @param pluginName
   */
  getRegisteredTools(pluginName) {
    var _this$registeredTools2, _this$registeredTools3, _this$logger5, _this$logger6, _this$logger7;
    const tools = Array.from((_this$registeredTools2 = (_this$registeredTools3 = this.registeredTools) === null || _this$registeredTools3 === void 0 ? void 0 : _this$registeredTools3.get(pluginName)) !== null && _this$registeredTools2 !== void 0 ? _this$registeredTools2 : new Set());
    (_this$logger5 = this.logger) === null || _this$logger5 === void 0 ? void 0 : _this$logger5.debug('AppContextService:getRegisteredTools');
    (_this$logger6 = this.logger) === null || _this$logger6 === void 0 ? void 0 : _this$logger6.debug(`pluginName: ${pluginName}`);
    (_this$logger7 = this.logger) === null || _this$logger7 === void 0 ? void 0 : _this$logger7.debug(`tools: ${tools.map(tool => tool.name).join(', ')}`);
    return tools;
  }

  /**
   * Register features to be used by the Elastic Assistant
   *
   * @param pluginName
   * @param features
   */
  registerFeatures(pluginName, features) {
    var _this$logger8, _this$logger9, _this$logger10;
    (_this$logger8 = this.logger) === null || _this$logger8 === void 0 ? void 0 : _this$logger8.debug('AppContextService:registerFeatures');
    (_this$logger9 = this.logger) === null || _this$logger9 === void 0 ? void 0 : _this$logger9.debug(`pluginName: ${pluginName}`);
    (_this$logger10 = this.logger) === null || _this$logger10 === void 0 ? void 0 : _this$logger10.debug(() => `features: ${Object.entries(features).map(([feature, enabled]) => `${feature}:${enabled}`).join(', ')}`);
    if (!this.registeredFeatures.has(pluginName)) {
      var _this$logger11;
      (_this$logger11 = this.logger) === null || _this$logger11 === void 0 ? void 0 : _this$logger11.debug('plugin has no features, initializing...');
      this.registeredFeatures.set(pluginName, _elasticAssistantCommon.defaultAssistantFeatures);
    }
    const registeredFeatures = this.registeredFeatures.get(pluginName);
    if (registeredFeatures != null) {
      this.registeredFeatures.set(pluginName, {
        ...registeredFeatures,
        ...features
      });
    }
  }

  /**
   * Get the registered features
   *
   * @param pluginName
   */
  getRegisteredFeatures(pluginName) {
    var _this$registeredFeatu, _this$registeredFeatu2, _this$logger12, _this$logger13, _this$logger14;
    const features = (_this$registeredFeatu = (_this$registeredFeatu2 = this.registeredFeatures) === null || _this$registeredFeatu2 === void 0 ? void 0 : _this$registeredFeatu2.get(pluginName)) !== null && _this$registeredFeatu !== void 0 ? _this$registeredFeatu : _elasticAssistantCommon.defaultAssistantFeatures;
    (_this$logger12 = this.logger) === null || _this$logger12 === void 0 ? void 0 : _this$logger12.debug('AppContextService:getRegisteredFeatures');
    (_this$logger13 = this.logger) === null || _this$logger13 === void 0 ? void 0 : _this$logger13.debug(`pluginName: ${pluginName}`);
    (_this$logger14 = this.logger) === null || _this$logger14 === void 0 ? void 0 : _this$logger14.debug(() => `features: ${Object.entries(features).map(([feature, enabled]) => `${feature}:${enabled}`).join(', ')}`);
    return features;
  }
}
const appContextService = exports.appContextService = new AppContextService();