"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerProfileProviders = exports.registerEnabledProfileProviders = void 0;
var _profile = require("./example/example_data_source_profile/profile");
var _example_document_profile = require("./example/example_document_profile");
var _example_root_profile = require("./example/example_root_profile");
var _logs_data_source_profile = require("./observability/logs_data_source_profile");
var _log_document_profile = require("./observability/log_document_profile");
var _security_root_profile = require("./security/security_root_profile");
var _profile_provider_services = require("./profile_provider_services");
var _observability_root_profile = require("./observability/observability_root_profile");
var _deprecation_logs = require("./common/deprecation_logs");
var _classic_nav_root_profile = require("./common/classic_nav_root_profile");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Register profile providers for root, data source, and document contexts to the profile profile services
 * @param options Register profile provider options
 */
const registerProfileProviders = async ({
  rootProfileService,
  dataSourceProfileService,
  documentProfileService,
  enabledExperimentalProfileIds,
  services
}) => {
  const providerServices = await (0, _profile_provider_services.createProfileProviderServices)(services);
  const rootProfileProviders = createRootProfileProviders(providerServices);
  const dataSourceProfileProviders = createDataSourceProfileProviders(providerServices);
  const documentProfileProviders = createDocumentProfileProviders(providerServices);
  registerEnabledProfileProviders({
    profileService: rootProfileService,
    providers: rootProfileProviders,
    enabledExperimentalProfileIds
  });
  registerEnabledProfileProviders({
    profileService: dataSourceProfileService,
    providers: dataSourceProfileProviders,
    enabledExperimentalProfileIds
  });
  registerEnabledProfileProviders({
    profileService: documentProfileService,
    providers: documentProfileProviders,
    enabledExperimentalProfileIds
  });
};

/**
 * Register enabled profile providers to the provided profile service
 * @param options Register enabled profile providers options
 */
exports.registerProfileProviders = registerProfileProviders;
const registerEnabledProfileProviders = ({
  profileService,
  providers: availableProviders,
  enabledExperimentalProfileIds = []
}) => {
  for (const provider of availableProviders) {
    if (!provider.isExperimental || enabledExperimentalProfileIds.includes(provider.profileId)) {
      profileService.registerProvider(provider);
    }
  }
};

/**
 * Creates the available root profile providers
 * @param providerServices The profile provider services
 * @returns An array of available root profile providers
 */
exports.registerEnabledProfileProviders = registerEnabledProfileProviders;
const createRootProfileProviders = providerServices => [(0, _example_root_profile.createExampleRootProfileProvider)(), (0, _example_root_profile.createExampleSolutionViewRootProfileProvider)(), (0, _classic_nav_root_profile.createClassicNavRootProfileProvider)(providerServices), (0, _security_root_profile.createSecurityRootProfileProvider)(providerServices), (0, _observability_root_profile.createObservabilityRootProfileProvider)(providerServices)];

/**
 * Creates the available data source profile providers
 * @param providerServices The profile provider services
 * @returns An array of available data source profile providers
 */
const createDataSourceProfileProviders = providerServices => [(0, _profile.createExampleDataSourceProfileProvider)(), (0, _deprecation_logs.createDeprecationLogsDataSourceProfileProvider)(), ...(0, _logs_data_source_profile.createObservabilityLogsDataSourceProfileProviders)(providerServices)];

/**
 * Creates the available document profile providers
 * @param providerServices The profile provider services
 * @returns An array of available document profile providers
 */
const createDocumentProfileProviders = providerServices => [(0, _example_document_profile.createExampleDocumentProfileProvider)(), (0, _log_document_profile.createObservabilityLogDocumentProfileProvider)(providerServices)];