"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetAppMenu = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createGetAppMenu = services => prev => params => {
  const prevValue = prev(params);
  return {
    appMenuRegistry: registry => {
      // Register custom link actions
      registerDatasetQualityLink(registry, services);
      // Register alerts sub menu actions
      registerCreateSLOAction(registry, services, params);
      registerCustomThresholdRuleAction(registry, services, params);
      return prevValue.appMenuRegistry(registry);
    }
  };
};
exports.createGetAppMenu = createGetAppMenu;
const registerDatasetQualityLink = (registry, {
  share,
  timefilter
}) => {
  const dataQualityLocator = share === null || share === void 0 ? void 0 : share.url.locators.get(_deeplinksObservability.DATA_QUALITY_LOCATOR_ID);
  if (dataQualityLocator) {
    registry.registerCustomAction({
      id: 'dataset-quality-link',
      type: _discoverUtils.AppMenuActionType.custom,
      controlProps: {
        label: _i18n.i18n.translate('discover.observabilitySolution.appMenu.datasets', {
          defaultMessage: 'Data sets'
        }),
        testId: 'discoverAppMenuDatasetQualityLink',
        onClick: ({
          onFinishAction
        }) => {
          const refresh = timefilter.getRefreshInterval();
          const {
            from,
            to
          } = timefilter.getTime();
          dataQualityLocator.navigate({
            filters: {
              timeRange: {
                from: from !== null && from !== void 0 ? from : 'now-24h',
                to: to !== null && to !== void 0 ? to : 'now',
                refresh
              }
            }
          });
          onFinishAction();
        }
      }
    });
  }
};
const registerCustomThresholdRuleAction = (registry, {
  data,
  triggersActionsUi
}, {
  dataView
}) => {
  registry.registerCustomActionUnderSubmenu(_discoverUtils.AppMenuActionId.alerts, {
    id: 'custom-threshold-rule',
    type: _discoverUtils.AppMenuActionType.custom,
    order: 101,
    controlProps: {
      label: _i18n.i18n.translate('discover.observabilitySolution.appMenu.customThresholdRule', {
        defaultMessage: 'Create custom threshold rule'
      }),
      iconType: 'bell',
      testId: 'discoverAppMenuCustomThresholdRule',
      onClick: ({
        onFinishAction
      }) => {
        const index = dataView === null || dataView === void 0 ? void 0 : dataView.toMinimalSpec();
        const {
          filters,
          query
        } = data.query.getState();
        return triggersActionsUi.getAddRuleFlyout({
          consumer: 'logs',
          ruleTypeId: _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID,
          canChangeTrigger: false,
          initialValues: {
            params: {
              searchConfiguration: {
                index,
                query,
                filter: filters
              }
            }
          },
          onClose: onFinishAction
        });
      }
    }
  });
};
const registerCreateSLOAction = (registry, {
  data,
  discoverShared
}, {
  dataView,
  isEsqlMode
}) => {
  const sloFeature = discoverShared.features.registry.getById('observability-create-slo');
  if (sloFeature) {
    registry.registerCustomActionUnderSubmenu(_discoverUtils.AppMenuActionId.alerts, {
      id: 'create-slo',
      type: _discoverUtils.AppMenuActionType.custom,
      order: 102,
      controlProps: {
        label: _i18n.i18n.translate('discover.observabilitySolution.appMenu.slo', {
          defaultMessage: 'Create SLO'
        }),
        iconType: 'visGauge',
        testId: 'discoverAppMenuCreateSlo',
        onClick: ({
          onFinishAction
        }) => {
          const index = dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern();
          const timestampField = dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName;
          const {
            filters,
            query: kqlQuery
          } = data.query.getState();
          const filter = isEsqlMode ? {} : {
            kqlQuery: (0, _esQuery.isOfQueryType)(kqlQuery) ? kqlQuery.query : '',
            filters: filters === null || filters === void 0 ? void 0 : filters.map(({
              meta,
              query
            }) => ({
              meta,
              query
            }))
          };
          return sloFeature.createSLOFlyout({
            initialValues: {
              indicator: {
                type: 'sli.kql.custom',
                params: {
                  index,
                  timestampField,
                  filter
                }
              }
            },
            onClose: onFinishAction
          });
        }
      }
    });
  }
};