"use strict";

var _scout = require("@kbn/scout");
var _fixtures = require("../fixtures");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

_fixtures.spaceTest.describe('Discover app - errors', {
  tag: _scout.tags.ESS_ONLY
}, () => {
  _fixtures.spaceTest.beforeAll(async ({
    scoutSpace
  }) => {
    await scoutSpace.savedObjects.cleanStandardList();
    await scoutSpace.savedObjects.load(_fixtures.testData.KBN_ARCHIVES.INVALID_SCRIPTED_FIELD);
    await scoutSpace.uiSettings.setDefaultTime({
      from: _fixtures.testData.LOGSTASH_DEFAULT_START_TIME,
      to: _fixtures.testData.LOGSTASH_DEFAULT_END_TIME
    });
  });
  _fixtures.spaceTest.beforeEach(async ({
    browserAuth,
    pageObjects
  }) => {
    await browserAuth.loginAsViewer();
    await pageObjects.discover.goto();
  });
  _fixtures.spaceTest.afterAll(async ({
    scoutSpace
  }) => {
    await scoutSpace.savedObjects.cleanStandardList();
  });
  (0, _fixtures.spaceTest)('should render invalid scripted field error', async ({
    page
  }) => {
    await page.testSubj.locator('discoverErrorCalloutTitle').waitFor({
      state: 'visible'
    });
    await (0, _scout.expect)(page.testSubj.locator('painlessStackTrace'), 'Painless error stacktrace should be displayed').toBeVisible();
  });
});