"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorMessage = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const readMore = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssue.failedDocs.erros.message.readMore', {
  defaultMessage: 'Read more'
});
const readLess = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssue.failedDocs.erros.message.readLess', {
  defaultMessage: 'Read less'
});
const MAX_CHAR_LENGTH = 200;
const readMoreMessageContent = message => {
  return `${message.slice(0, MAX_CHAR_LENGTH)}...`;
};
const ErrorMessage = ({
  errorMessage
}) => {
  const showReadMoreOrLess = errorMessage.length > MAX_CHAR_LENGTH;
  const [message, setMessage] = _react.default.useState(showReadMoreOrLess ? readMoreMessageContent(errorMessage) : errorMessage);
  const handleReadMore = () => {
    setMessage(prev => {
      return prev.length === errorMessage.length ? readMoreMessageContent(errorMessage) : errorMessage;
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    language: "js",
    style: {
      fontWeight: 'normal'
    }
  }, message), showReadMoreOrLess && /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, /*#__PURE__*/_react.default.createElement("button", {
    onClick: handleReadMore,
    style: {
      fontWeight: 'bold'
    }
  }, message.length === errorMessage.length ? readLess : readMore)));
};
exports.ErrorMessage = ErrorMessage;