"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DegradedFieldInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../../hooks");
var _translations = require("../../../../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DegradedFieldInfo = () => {
  var _degradedFieldAnalysi;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    degradedFieldValues,
    isAnalysisInProgress,
    degradedFieldAnalysisFormattedResult,
    degradedFieldAnalysis
  } = (0, _hooks.useQualityIssues)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `datasetQualityDetailsDegradedFieldFlyoutFieldsList-cause`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _translations.degradedFieldPotentialCauseColumnName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutFieldValue-cause",
    grow: 2
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: degradedFieldAnalysisFormattedResult === null || degradedFieldAnalysisFormattedResult === void 0 ? void 0 : degradedFieldAnalysisFormattedResult.tooltipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement("strong", null, degradedFieldAnalysisFormattedResult === null || degradedFieldAnalysisFormattedResult === void 0 ? void 0 : degradedFieldAnalysisFormattedResult.potentialCause)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), !isAnalysisInProgress && (degradedFieldAnalysis === null || degradedFieldAnalysis === void 0 ? void 0 : degradedFieldAnalysis.isFieldLimitIssue) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `datasetQualityDetailsDegradedFieldFlyoutFieldsList-mappingLimit`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _translations.degradedFieldCurrentFieldLimitColumnName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutFieldValue-mappingLimit",
    grow: 2
  }, /*#__PURE__*/_react.default.createElement("span", null, degradedFieldAnalysis.totalFieldLimit))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  })), !isAnalysisInProgress && (degradedFieldAnalysisFormattedResult === null || degradedFieldAnalysisFormattedResult === void 0 ? void 0 : degradedFieldAnalysisFormattedResult.shouldDisplayIgnoredValuesAndLimit) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": 'datasetQualityDetailsDegradedFieldFlyoutFieldsList-characterLimit'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _translations.degradedFieldMaximumCharacterLimitColumnName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutFieldValue-characterLimit",
    css: {
      maxWidth: '64%'
    },
    grow: 2
  }, /*#__PURE__*/_react.default.createElement("span", null, degradedFieldAnalysis === null || degradedFieldAnalysis === void 0 ? void 0 : (_degradedFieldAnalysi = degradedFieldAnalysis.fieldMapping) === null || _degradedFieldAnalysi === void 0 ? void 0 : _degradedFieldAnalysi.ignore_above))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `datasetQualityDetailsDegradedFieldFlyoutFieldsList-values`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _translations.degradedFieldValuesColumnName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutFieldValue-values",
    css: {
      maxWidth: '64%'
    },
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    gutterSize: "s"
  }, degradedFieldValues === null || degradedFieldValues === void 0 ? void 0 : degradedFieldValues.values.map((value, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    key: idx
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: euiTheme.colors.vis.euiColorVis3
  }, /*#__PURE__*/_react.default.createElement("strong", null, value))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  })));
};
exports.DegradedFieldInfo = DegradedFieldInfo;