"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FileDataVisualizerLite = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _kibana_services = require("../kibana_services");
var _file_upload_lite_view = require("./file_upload_lite_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileDataVisualizerLite = ({
  getAdditionalLinks,
  resultLinks,
  setUploadResults,
  autoAddInference,
  indexSettings,
  onClose
}) => {
  var _cloud$CloudContextPr;
  const coreStart = (0, _kibana_services.getCoreStart)();
  const {
    data,
    maps,
    embeddable,
    share,
    fileUpload,
    cloud,
    fieldFormats
  } = (0, _kibana_services.getPluginsStart)();
  const services = {
    ...coreStart,
    data,
    maps,
    embeddable,
    share,
    fileUpload,
    fieldFormats
  };
  const EmptyContext = ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  const CloudContext = (_cloud$CloudContextPr = cloud === null || cloud === void 0 ? void 0 : cloud.CloudContextProvider) !== null && _cloud$CloudContextPr !== void 0 ? _cloud$CloudContextPr : EmptyContext;
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStart, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...services
    }
  }, /*#__PURE__*/_react.default.createElement(CloudContext, null, /*#__PURE__*/_react.default.createElement(_file_upload_lite_view.FileUploadLiteView, {
    dataStart: data,
    http: coreStart.http,
    fileUpload: fileUpload,
    getAdditionalLinks: getAdditionalLinks,
    resultLinks: resultLinks,
    capabilities: coreStart.application.capabilities,
    setUploadResults: setUploadResults,
    autoAddInference: autoAddInference,
    indexSettings: indexSettings,
    onClose: onClose
  }))));
};

// exporting as default so it can be used with React.lazy
// eslint-disable-next-line import/no-default-export
exports.FileDataVisualizerLite = FileDataVisualizerLite;
var _default = exports.default = FileDataVisualizerLite;