"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SemanticTextForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _utils = require("./utils");
var _kibana_context = require("../../../kibana_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SemanticTextForm = ({
  addCombinedField,
  hasNameCollision,
  results
}) => {
  const {
    services: {
      http
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const [inferenceEndpoints, setInferenceEndpoints] = (0, _react.useState)([]);
  const [selectedInferenceEndpoint, setSelectedInferenceEndpoint] = (0, _react.useState)();
  const [selectedFieldOption, setSelectedFieldOption] = (0, _react.useState)();
  const [renameToFieldOption, setRenameToFieldOption] = (0, _react.useState)('');
  const [fieldError, setFieldError] = (0, _react.useState)();
  const fieldOptions = (0, _react.useMemo)(() => (0, _utils.getFieldNames)(results).map(columnName => {
    return {
      value: columnName,
      text: columnName
    };
  }), [results]);
  (0, _react.useEffect)(() => {
    var _fieldOptions$0$value;
    setSelectedFieldOption((_fieldOptions$0$value = fieldOptions[0].value) !== null && _fieldOptions$0$value !== void 0 ? _fieldOptions$0$value : null);
  }, [fieldOptions]);
  (0, _react.useEffect)(() => {
    http.fetch('/internal/data_visualizer/inference_endpoints', {
      method: 'GET',
      version: '1'
    }).then(response => {
      var _inferenceEndpointOpt, _inferenceEndpointOpt2;
      const inferenceEndpointOptions = response.map(endpoint => ({
        value: endpoint.inference_id,
        text: endpoint.inference_id
      }));
      setInferenceEndpoints(inferenceEndpointOptions);
      setSelectedInferenceEndpoint((_inferenceEndpointOpt = (_inferenceEndpointOpt2 = inferenceEndpointOptions[0]) === null || _inferenceEndpointOpt2 === void 0 ? void 0 : _inferenceEndpointOpt2.value) !== null && _inferenceEndpointOpt !== void 0 ? _inferenceEndpointOpt : undefined);
    });
  }, [http]);
  (0, _react.useEffect)(() => {
    if (selectedFieldOption !== null && selectedFieldOption !== void 0 && selectedFieldOption.includes('.')) {
      setRenameToFieldOption(selectedFieldOption.split('.').pop());
    } else {
      setRenameToFieldOption(`${selectedFieldOption}_semantic`);
    }
  }, [selectedFieldOption]);
  const onSubmit = () => {
    if (renameToFieldOption === '' || renameToFieldOption === undefined || selectedFieldOption === undefined || selectedInferenceEndpoint === undefined) {
      return;
    }
    addCombinedField((0, _utils.createSemanticTextCombinedField)(renameToFieldOption, selectedFieldOption), mappings => {
      if (renameToFieldOption === undefined || selectedFieldOption === undefined) {
        return mappings;
      }
      const newMappings = (0, _lodash.cloneDeep)(mappings);
      newMappings.properties[renameToFieldOption !== null && renameToFieldOption !== void 0 ? renameToFieldOption : selectedFieldOption] = {
        // @ts-ignore types are missing semantic_text
        type: 'semantic_text',
        inference_id: selectedInferenceEndpoint
      };
      return newMappings;
    }, pipeline => {
      const newPipeline = (0, _lodash.cloneDeep)(pipeline);
      if (renameToFieldOption !== null) {
        newPipeline.processors.push({
          set: {
            field: renameToFieldOption,
            copy_from: selectedFieldOption
          }
        });
      }
      return newPipeline;
    });
  };
  (0, _useDebounce.default)(() => {
    if (renameToFieldOption === undefined) {
      return;
    }
    const error = hasNameCollision(renameToFieldOption) ? (0, _utils.getNameCollisionMsg)(renameToFieldOption) : undefined;
    setFieldError(error);
  }, 250, [renameToFieldOption]);
  const isInvalid = (0, _react.useMemo)(() => {
    return !selectedInferenceEndpoint || !selectedFieldOption || renameToFieldOption === '' || fieldError !== undefined;
  }, [selectedInferenceEndpoint, selectedFieldOption, renameToFieldOption, fieldError]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.dataVisualizer.file.semanticTextForm.fieldLabel', {
      defaultMessage: 'Field'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: fieldOptions,
    value: selectedFieldOption,
    onChange: e => setSelectedFieldOption(e.target.value)
  })), renameToFieldOption !== null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.dataVisualizer.file.semanticTextForm.copyFieldLabel', {
      defaultMessage: 'Copy to field'
    }),
    isInvalid: fieldError !== undefined,
    error: [fieldError]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.dataVisualizer.file.semanticTextForm.copyFieldLabel.placeholder', {
      defaultMessage: 'Field name'
    }),
    value: renameToFieldOption,
    onChange: e => setRenameToFieldOption(e.target.value),
    "aria-label": "field name"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.dataVisualizer.file.semanticTextForm.inferenceLabel', {
      defaultMessage: 'Inference endpoint'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: inferenceEndpoints,
    value: selectedInferenceEndpoint,
    onChange: e => setSelectedInferenceEndpoint(e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "right"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    fill: true,
    disabled: isInvalid,
    onClick: onSubmit
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.geoPointForm.submitButtonLabel",
    defaultMessage: "Add"
  }))));
};
exports.SemanticTextForm = SemanticTextForm;