"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutPanelsContext = exports.Panels = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
require("./flyout_panels.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

let idx = 0;
const panelId = () => idx++;
const flyoutPanelsContext = /*#__PURE__*/(0, _react.createContext)({
  addPanel() {
    return () => {};
  }
});
const Panels = ({
  maxWidth,
  flyoutClassName,
  ...props
}) => {
  const flyoutDOMelement = (0, _react.useMemo)(() => {
    const el = document.getElementsByClassName(flyoutClassName);
    if (el.length === 0) {
      // throw new Error(`Flyout with className "${flyoutClassName}" not found.`);
      return null;
    }
    return el.item(0);
  }, [flyoutClassName]);
  const [panels, setPanels] = (0, _react.useState)({});
  const removePanel = (0, _react.useCallback)(id => {
    setPanels(prev => {
      const {
        [id]: panelToRemove,
        ...rest
      } = prev;
      return rest;
    });
  }, []);
  const addPanel = (0, _react.useCallback)(panel => {
    const nextId = panelId();
    setPanels(prev => {
      return {
        ...prev,
        [nextId]: panel
      };
    });
    return removePanel.bind(null, nextId);
  }, [removePanel]);
  const ctx = (0, _react.useMemo)(() => ({
    addPanel
  }), [addPanel]);
  (0, _react.useLayoutEffect)(() => {
    if (!flyoutDOMelement) {
      return;
    }
    const totalPercentWidth = Math.min(100, Object.values(panels).reduce((acc, {
      width = 0
    }) => acc + width, 0));
    const currentWidth = maxWidth * totalPercentWidth / 100;
    flyoutDOMelement.style.maxWidth = `${currentWidth}px`;
  }, [panels, maxWidth, flyoutClassName, flyoutDOMelement]);
  return /*#__PURE__*/_react.default.createElement(flyoutPanelsContext.Provider, {
    value: ctx
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    className: "fieldEditor__flyoutPanels",
    gutterSize: "none"
  }, props)));
};
exports.Panels = Panels;
const useFlyoutPanelsContext = () => {
  const ctx = (0, _react.useContext)(flyoutPanelsContext);
  if (ctx === undefined) {
    throw new Error('<Panel /> must be used within a <Panels /> wrapper');
  }
  return ctx;
};
exports.useFlyoutPanelsContext = useFlyoutPanelsContext;