"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardAttributesOut = dashboardAttributesOut;
exports.itemAttrsToSavedObjectAttrs = exports.getResultV3ToV2 = void 0;
exports.savedObjectToItem = savedObjectToItem;
var _uuid = require("uuid");
var _lodash = require("lodash");
var _common = require("@kbn/controls-plugin/common");
var _common2 = require("@kbn/data-plugin/common");
var _content_management = require("../../../common/content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function controlGroupInputOut(controlGroupInput) {
  if (!controlGroupInput) {
    return;
  }
  const {
    panelsJSON,
    ignoreParentSettingsJSON,
    controlStyle = _common.DEFAULT_CONTROL_LABEL_POSITION,
    chainingSystem = _common.DEFAULT_CONTROL_CHAINING,
    showApplySelections = !_common.DEFAULT_AUTO_APPLY_SELECTIONS
  } = controlGroupInput;
  const controls = panelsJSON ? Object.entries(JSON.parse(panelsJSON)).map(([id, {
    explicitInput,
    type,
    grow = _common.DEFAULT_CONTROL_GROW,
    width = _common.DEFAULT_CONTROL_WIDTH,
    order
  }]) => ({
    controlConfig: explicitInput,
    id,
    grow,
    order,
    type,
    width
  })) : [];
  const {
    ignoreFilters = _common.DEFAULT_IGNORE_PARENT_SETTINGS.ignoreFilters,
    ignoreQuery = _common.DEFAULT_IGNORE_PARENT_SETTINGS.ignoreQuery,
    ignoreTimerange = _common.DEFAULT_IGNORE_PARENT_SETTINGS.ignoreTimerange,
    ignoreValidations = _common.DEFAULT_IGNORE_PARENT_SETTINGS.ignoreValidations
  } = ignoreParentSettingsJSON ? JSON.parse(ignoreParentSettingsJSON) : {};

  // try to maintain a consistent (alphabetical) order of keys
  return {
    autoApplySelections: !showApplySelections,
    chainingSystem: chainingSystem,
    controls,
    labelPosition: controlStyle,
    ignoreParentSettings: {
      ignoreFilters,
      ignoreQuery,
      ignoreTimerange,
      ignoreValidations
    }
  };
}
function kibanaSavedObjectMetaOut(kibanaSavedObjectMeta) {
  const {
    searchSourceJSON
  } = kibanaSavedObjectMeta;
  if (!searchSourceJSON) {
    return {};
  }
  // Dashboards do not yet support ES|QL (AggregateQuery) in the search source
  return {
    searchSource: (0, _common2.parseSearchSourceJSON)(searchSourceJSON)
  };
}
function optionsOut(optionsJSON) {
  const {
    hidePanelTitles = _content_management.DEFAULT_DASHBOARD_OPTIONS.hidePanelTitles,
    useMargins = _content_management.DEFAULT_DASHBOARD_OPTIONS.useMargins,
    syncColors = _content_management.DEFAULT_DASHBOARD_OPTIONS.syncColors,
    syncCursor = _content_management.DEFAULT_DASHBOARD_OPTIONS.syncCursor,
    syncTooltips = _content_management.DEFAULT_DASHBOARD_OPTIONS.syncTooltips
  } = JSON.parse(optionsJSON);
  return {
    hidePanelTitles,
    useMargins,
    syncColors,
    syncCursor,
    syncTooltips
  };
}
function panelsOut(panelsJSON) {
  const panels = JSON.parse(panelsJSON);
  return panels.map(({
    embeddableConfig,
    gridData,
    id,
    panelIndex,
    panelRefName,
    title,
    type,
    version
  }) => ({
    gridData,
    id,
    panelConfig: embeddableConfig,
    panelIndex,
    panelRefName,
    title,
    type,
    version
  }));
}
function dashboardAttributesOut(attributes) {
  const {
    controlGroupInput,
    description,
    kibanaSavedObjectMeta,
    optionsJSON,
    panelsJSON,
    refreshInterval,
    timeFrom,
    timeRestore,
    timeTo,
    title,
    version
  } = attributes;
  // try to maintain a consistent (alphabetical) order of keys
  return {
    ...(controlGroupInput && {
      controlGroupInput: controlGroupInputOut(controlGroupInput)
    }),
    ...(description && {
      description
    }),
    ...(kibanaSavedObjectMeta && {
      kibanaSavedObjectMeta: kibanaSavedObjectMetaOut(kibanaSavedObjectMeta)
    }),
    ...(optionsJSON && {
      options: optionsOut(optionsJSON)
    }),
    ...(panelsJSON && {
      panels: panelsOut(panelsJSON)
    }),
    ...(refreshInterval && {
      refreshInterval: {
        pause: refreshInterval.pause,
        value: refreshInterval.value
      }
    }),
    ...(timeFrom && {
      timeFrom
    }),
    timeRestore: timeRestore !== null && timeRestore !== void 0 ? timeRestore : false,
    ...(timeTo && {
      timeTo
    }),
    title,
    ...(version && {
      version
    })
  };
}
function controlGroupInputIn(controlGroupInput) {
  if (!controlGroupInput) {
    return;
  }
  const {
    controls,
    ignoreParentSettings,
    labelPosition,
    chainingSystem,
    autoApplySelections
  } = controlGroupInput;
  const updatedControls = Object.fromEntries(controls.map(({
    controlConfig,
    id = (0, _uuid.v4)(),
    ...restOfControl
  }) => {
    return [id, {
      ...restOfControl,
      explicitInput: {
        ...controlConfig,
        id
      }
    }];
  }));
  return {
    chainingSystem,
    controlStyle: labelPosition,
    ignoreParentSettingsJSON: JSON.stringify(ignoreParentSettings),
    panelsJSON: JSON.stringify(updatedControls),
    showApplySelections: !autoApplySelections
  };
}
function panelsIn(panels) {
  const updatedPanels = panels.map(({
    panelIndex,
    gridData,
    panelConfig,
    ...restPanel
  }) => {
    const idx = panelIndex !== null && panelIndex !== void 0 ? panelIndex : (0, _uuid.v4)();
    return {
      ...restPanel,
      embeddableConfig: panelConfig,
      panelIndex: idx,
      gridData: {
        ...gridData,
        i: idx
      }
    };
  });
  return JSON.stringify(updatedPanels);
}
function kibanaSavedObjectMetaIn(kibanaSavedObjectMeta) {
  const {
    searchSource
  } = kibanaSavedObjectMeta;
  return {
    searchSourceJSON: JSON.stringify(searchSource !== null && searchSource !== void 0 ? searchSource : {})
  };
}
const getResultV3ToV2 = result => {
  const {
    meta,
    item
  } = result;
  const {
    attributes,
    ...rest
  } = item;
  const {
    controlGroupInput,
    description,
    kibanaSavedObjectMeta,
    options,
    panels,
    refreshInterval,
    timeFrom,
    timeRestore,
    timeTo,
    title,
    version
  } = attributes;
  const v2Attributes = {
    ...(controlGroupInput && {
      controlGroupInput: controlGroupInputIn(controlGroupInput)
    }),
    description,
    ...(kibanaSavedObjectMeta && {
      kibanaSavedObjectMeta: kibanaSavedObjectMetaIn(kibanaSavedObjectMeta)
    }),
    ...(options && {
      optionsJSON: JSON.stringify(options)
    }),
    panelsJSON: panels ? panelsIn(panels) : '[]',
    refreshInterval,
    ...(timeFrom && {
      timeFrom
    }),
    timeRestore,
    ...(timeTo && {
      timeTo
    }),
    title,
    ...(version && {
      version
    })
  };
  return {
    meta,
    item: {
      ...rest,
      attributes: v2Attributes
    }
  };
};
exports.getResultV3ToV2 = getResultV3ToV2;
const itemAttrsToSavedObjectAttrs = attributes => {
  try {
    const {
      controlGroupInput,
      kibanaSavedObjectMeta,
      options,
      panels,
      ...rest
    } = attributes;
    const soAttributes = {
      ...rest,
      ...(controlGroupInput && {
        controlGroupInput: controlGroupInputIn(controlGroupInput)
      }),
      ...(options && {
        optionsJSON: JSON.stringify(options)
      }),
      ...(panels && {
        panelsJSON: panelsIn(panels)
      }),
      ...(kibanaSavedObjectMeta && {
        kibanaSavedObjectMeta: kibanaSavedObjectMetaIn(kibanaSavedObjectMeta)
      })
    };
    return {
      attributes: soAttributes,
      error: null
    };
  } catch (e) {
    return {
      attributes: null,
      error: e
    };
  }
};
exports.itemAttrsToSavedObjectAttrs = itemAttrsToSavedObjectAttrs;
function savedObjectToItem(savedObject, partial, {
  allowedAttributes,
  allowedReferences
} = {}) {
  const {
    id,
    type,
    updated_at: updatedAt,
    updated_by: updatedBy,
    created_at: createdAt,
    created_by: createdBy,
    attributes,
    error,
    namespaces,
    references,
    version,
    managed
  } = savedObject;
  try {
    const attributesOut = allowedAttributes ? (0, _lodash.pick)(dashboardAttributesOut(attributes), allowedAttributes) : dashboardAttributesOut(attributes);

    // if includeReferences is provided, only include references of those types
    const referencesOut = allowedReferences ? references === null || references === void 0 ? void 0 : references.filter(reference => allowedReferences.includes(reference.type)) : references;
    return {
      item: {
        id,
        type,
        updatedAt,
        updatedBy,
        createdAt,
        createdBy,
        attributes: attributesOut,
        error,
        namespaces,
        references: referencesOut,
        version,
        managed
      },
      error: null
    };
  } catch (e) {
    return {
      item: null,
      error: e
    };
  }
}