"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Group = Group;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function Group({
  group
}) {
  const listItems = (0, _react.useMemo)(() => group.items.map(item => ({
    key: item.id,
    size: 's',
    toolTipText: item.description,
    toolTipProps: {
      position: 'right'
    },
    showToolTip: true,
    label: !item.isDeprecated ? item.name : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      responsive: false,
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, item.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.editorMenu.deprecatedTag",
      defaultMessage: "Deprecated"
    })))),
    onClick: item.onClick,
    iconType: item.icon,
    isDisabled: item.isDisabled,
    'data-test-subj': item['data-test-subj'],
    role: 'menuitem'
  })), [group.items]);
  const titleId = `${group.id}-group`;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: titleId
  }, group.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    "aria-labelledby": titleId,
    size: "s",
    gutterSize: "none",
    maxWidth: false,
    flush: true,
    listItems: listItems,
    role: "menu"
  }));
}