"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeTrackOverlay = initializeTrackOverlay;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeTrackOverlay(setFocusedPanelId) {
  let overlayRef;
  const hasOverlays$ = new _rxjs.BehaviorSubject(false);
  function clearOverlays() {
    var _overlayRef;
    hasOverlays$.next(false);
    setFocusedPanelId(undefined);
    (_overlayRef = overlayRef) === null || _overlayRef === void 0 ? void 0 : _overlayRef.close();
  }
  return {
    clearOverlays,
    hasOverlays$,
    openOverlay: (ref, options) => {
      clearOverlays();
      hasOverlays$.next(true);
      overlayRef = ref;
      if (options !== null && options !== void 0 && options.focusedPanelId) {
        setFocusedPanelId(options.focusedPanelId);
      }
    }
  };
}