"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeSettingsManager = initializeSettingsManager;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _default_dashboard_input = require("./default_dashboard_input");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeSettingsManager(initialState) {
  var _initialState$syncCol, _initialState$syncCur, _initialState$syncToo, _initialState$tags, _initialState$timeRes, _initialState$useMarg;
  const syncColors$ = new _rxjs.BehaviorSubject((_initialState$syncCol = initialState === null || initialState === void 0 ? void 0 : initialState.syncColors) !== null && _initialState$syncCol !== void 0 ? _initialState$syncCol : _default_dashboard_input.DEFAULT_DASHBOARD_INPUT.syncColors);
  function setSyncColors(syncColors) {
    if (syncColors !== syncColors$.value) syncColors$.next(syncColors);
  }
  const syncCursor$ = new _rxjs.BehaviorSubject((_initialState$syncCur = initialState === null || initialState === void 0 ? void 0 : initialState.syncCursor) !== null && _initialState$syncCur !== void 0 ? _initialState$syncCur : _default_dashboard_input.DEFAULT_DASHBOARD_INPUT.syncCursor);
  function setSyncCursor(syncCursor) {
    if (syncCursor !== syncCursor$.value) syncCursor$.next(syncCursor);
  }
  const syncTooltips$ = new _rxjs.BehaviorSubject((_initialState$syncToo = initialState === null || initialState === void 0 ? void 0 : initialState.syncTooltips) !== null && _initialState$syncToo !== void 0 ? _initialState$syncToo : _default_dashboard_input.DEFAULT_DASHBOARD_INPUT.syncTooltips);
  function setSyncTooltips(syncTooltips) {
    if (syncTooltips !== syncTooltips$.value) syncTooltips$.next(syncTooltips);
  }
  const tags$ = new _rxjs.BehaviorSubject((_initialState$tags = initialState === null || initialState === void 0 ? void 0 : initialState.tags) !== null && _initialState$tags !== void 0 ? _initialState$tags : _default_dashboard_input.DEFAULT_DASHBOARD_INPUT.tags);
  function setTags(tags) {
    if (!(0, _fastDeepEqual.default)(tags, tags$.value)) tags$.next(tags);
  }
  const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState !== null && initialState !== void 0 ? initialState : {});
  const timeRestore$ = new _rxjs.BehaviorSubject((_initialState$timeRes = initialState === null || initialState === void 0 ? void 0 : initialState.timeRestore) !== null && _initialState$timeRes !== void 0 ? _initialState$timeRes : _default_dashboard_input.DEFAULT_DASHBOARD_INPUT.timeRestore);
  function setTimeRestore(timeRestore) {
    if (timeRestore !== timeRestore$.value) timeRestore$.next(timeRestore);
  }
  const useMargins$ = new _rxjs.BehaviorSubject((_initialState$useMarg = initialState === null || initialState === void 0 ? void 0 : initialState.useMargins) !== null && _initialState$useMarg !== void 0 ? _initialState$useMarg : _default_dashboard_input.DEFAULT_DASHBOARD_INPUT.useMargins);
  function setUseMargins(useMargins) {
    if (useMargins !== useMargins$.value) useMargins$.next(useMargins);
  }
  function getSettings() {
    return {
      ...titleManager.serialize(),
      syncColors: syncColors$.value,
      syncCursor: syncCursor$.value,
      syncTooltips: syncTooltips$.value,
      tags: tags$.value,
      timeRestore: timeRestore$.value,
      useMargins: useMargins$.value
    };
  }
  function setSettings(settings) {
    setSyncColors(settings.syncColors);
    setSyncCursor(settings.syncCursor);
    setSyncTooltips(settings.syncTooltips);
    setTags(settings.tags);
    setTimeRestore(settings.timeRestore);
    setUseMargins(settings.useMargins);
    titleManager.api.setHideTitle(settings.hidePanelTitles);
    titleManager.api.setDescription(settings.description);
    titleManager.api.setTitle(settings.title);
  }
  return {
    api: {
      ...titleManager.api,
      getSettings,
      settings: {
        syncColors$,
        syncCursor$,
        syncTooltips$,
        useMargins$
      },
      setSettings,
      setTags,
      timeRestore$
    },
    comparators: {
      ...titleManager.comparators,
      syncColors: [syncColors$, setSyncColors],
      syncCursor: [syncCursor$, setSyncCursor],
      syncTooltips: [syncTooltips$, setSyncTooltips],
      timeRestore: [timeRestore$, setTimeRestore],
      useMargins: [useMargins$, setUseMargins]
    },
    internalApi: {
      getState: () => {
        var _settings$title, _settings$timeRestore, _settings$hidePanelTi;
        const settings = getSettings();
        return {
          ...settings,
          title: (_settings$title = settings.title) !== null && _settings$title !== void 0 ? _settings$title : '',
          timeRestore: (_settings$timeRestore = settings.timeRestore) !== null && _settings$timeRestore !== void 0 ? _settings$timeRestore : _default_dashboard_input.DEFAULT_DASHBOARD_INPUT.timeRestore,
          hidePanelTitles: (_settings$hidePanelTi = settings.hidePanelTitles) !== null && _settings$hidePanelTi !== void 0 ? _settings$hidePanelTi : _default_dashboard_input.DEFAULT_DASHBOARD_INPUT.hidePanelTitles
        };
      },
      reset: lastSavedState => {
        setSettings(lastSavedState);
      }
    }
  };
}