"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardDrilldownsService = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _actions = require("./actions");
var _embeddable_to_dashboard_drilldown = require("./embeddable_to_dashboard_drilldown");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DashboardDrilldownsService {
  bootstrap(core, plugins, {
    enableDrilldowns
  }) {
    if (enableDrilldowns) {
      this.setupDrilldowns(core, plugins);
    }
  }
  setupDrilldowns(core, {
    uiActionsEnhanced: uiActions
  }) {
    const start = (0, _public2.createStartServicesGetter)(core.getStartServices);
    const actionFlyoutCreateDrilldown = new _actions.FlyoutCreateDrilldownAction({
      start
    });
    uiActions.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, actionFlyoutCreateDrilldown);
    const actionFlyoutEditDrilldown = new _actions.FlyoutEditDrilldownAction({
      start
    });
    uiActions.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, actionFlyoutEditDrilldown);
    const dashboardToDashboardDrilldown = new _embeddable_to_dashboard_drilldown.EmbeddableToDashboardDrilldown({
      start
    });
    uiActions.registerDrilldown(dashboardToDashboardDrilldown);
  }
}
exports.DashboardDrilldownsService = DashboardDrilldownsService;