"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PointInTimeFinder = void 0;
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var _log = /*#__PURE__*/new WeakMap();
var _client = /*#__PURE__*/new WeakMap();
var _findOptions = /*#__PURE__*/new WeakMap();
var _internalOptions = /*#__PURE__*/new WeakMap();
var _open = /*#__PURE__*/new WeakMap();
var _pitId = /*#__PURE__*/new WeakMap();
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * @internal
 */

/**
 * @internal
 */

/**
 * @internal
 */
class PointInTimeFinder {
  constructor(findOptions, {
    logger,
    client,
    internalOptions
  }) {
    _classPrivateFieldInitSpec(this, _log, void 0);
    _classPrivateFieldInitSpec(this, _client, void 0);
    _classPrivateFieldInitSpec(this, _findOptions, void 0);
    _classPrivateFieldInitSpec(this, _internalOptions, void 0);
    _classPrivateFieldInitSpec(this, _open, false);
    _classPrivateFieldInitSpec(this, _pitId, void 0);
    _classPrivateFieldSet(_log, this, logger.get('point-in-time-finder'));
    _classPrivateFieldSet(_client, this, client);
    _classPrivateFieldSet(_internalOptions, this, internalOptions);
    _classPrivateFieldSet(_findOptions, this, {
      // Default to 1000 items per page as a tradeoff between
      // speed and memory consumption.
      perPage: 1000,
      ...findOptions
    });
  }
  async *find() {
    if (_classPrivateFieldGet(_open, this)) {
      throw new Error('Point In Time has already been opened for this finder instance. ' + 'Please call `close()` before calling `find()` again.');
    }

    // Open PIT and request our first page of hits
    await this.open();
    let lastResultsCount;
    let lastHitSortValue;
    do {
      const results = await this.findNext({
        findOptions: _classPrivateFieldGet(_findOptions, this),
        id: _classPrivateFieldGet(_pitId, this),
        searchAfter: lastHitSortValue
      });
      _classPrivateFieldSet(_pitId, this, results.pit_id);
      lastResultsCount = results.saved_objects.length;
      lastHitSortValue = this.getLastHitSortValue(results);
      _classPrivateFieldGet(_log, this).debug(`Collected [${lastResultsCount}] saved objects`);

      // Close PIT if this was our last page
      if (_classPrivateFieldGet(_pitId, this) && lastResultsCount < _classPrivateFieldGet(_findOptions, this).perPage) {
        await this.close();
      }

      // do not yield first page if empty, unless there are aggregations
      // (in which case we always want to return at least one page)
      if (lastResultsCount > 0 || _classPrivateFieldGet(_findOptions, this).aggs) {
        yield results;
      }

      // We've reached the end when there are fewer hits than our perPage size,
      // or when `close()` has been called.
    } while (_classPrivateFieldGet(_open, this) && lastResultsCount >= _classPrivateFieldGet(_findOptions, this).perPage);
    return;
  }
  async close() {
    try {
      if (_classPrivateFieldGet(_pitId, this)) {
        _classPrivateFieldGet(_log, this).debug(`Closing PIT for types [${_classPrivateFieldGet(_findOptions, this).type}]`);
        await _classPrivateFieldGet(_client, this).closePointInTime(_classPrivateFieldGet(_pitId, this), undefined, _classPrivateFieldGet(_internalOptions, this));
        _classPrivateFieldSet(_pitId, this, undefined);
      }
      _classPrivateFieldSet(_open, this, false);
    } catch (e) {
      _classPrivateFieldGet(_log, this).error(`Failed to close PIT for types [${_classPrivateFieldGet(_findOptions, this).type}]`);
      throw e;
    }
  }
  async open() {
    try {
      const {
        id
      } = await _classPrivateFieldGet(_client, this).openPointInTimeForType(_classPrivateFieldGet(_findOptions, this).type, {
        namespaces: _classPrivateFieldGet(_findOptions, this).namespaces
      }, _classPrivateFieldGet(_internalOptions, this));
      _classPrivateFieldSet(_pitId, this, id);
      _classPrivateFieldSet(_open, this, true);
    } catch (e) {
      var _e$output;
      // Since `find` swallows 404s, it is expected that finder will do the same,
      // so we only rethrow non-404 errors here.
      if (((_e$output = e.output) === null || _e$output === void 0 ? void 0 : _e$output.statusCode) !== 404) {
        _classPrivateFieldGet(_log, this).error(`Failed to open PIT for types [${_classPrivateFieldGet(_findOptions, this).type}]`);
        throw e;
      }
      _classPrivateFieldGet(_log, this).debug(`Unable to open PIT for types [${_classPrivateFieldGet(_findOptions, this).type}]: 404 ${e}`);
    }
  }
  async findNext({
    findOptions,
    id,
    searchAfter
  }) {
    try {
      var _findOptions$sortFiel, _findOptions$sortOrde;
      return await _classPrivateFieldGet(_client, this).find({
        ...findOptions,
        // Sort fields are required to use searchAfter, so we set some defaults here
        sortField: (_findOptions$sortFiel = findOptions.sortField) !== null && _findOptions$sortFiel !== void 0 ? _findOptions$sortFiel : 'updated_at',
        sortOrder: (_findOptions$sortOrde = findOptions.sortOrder) !== null && _findOptions$sortOrde !== void 0 ? _findOptions$sortOrde : 'desc',
        // Bump keep_alive by 2m on every new request to allow for the ES client
        // to make multiple retries in the event of a network failure.
        pit: id ? {
          id,
          keepAlive: '2m'
        } : undefined,
        searchAfter
      }, _classPrivateFieldGet(_internalOptions, this));
    } catch (e) {
      if (id) {
        // Clean up PIT on any errors.
        await this.close();
      }
      throw e;
    }
  }
  getLastHitSortValue(res) {
    if (res.saved_objects.length < 1) {
      return undefined;
    }
    return res.saved_objects[res.saved_objects.length - 1].sort;
  }
}
exports.PointInTimeFinder = PointInTimeFinder;