"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserConfirmationHandler = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getUserConfirmationHandler = ({
  overlayPromise,
  fallbackHandler = windowConfirm
}) => {
  let overlayConfirm;
  overlayPromise.then(overlay => {
    overlayConfirm = getOverlayConfirmHandler(overlay);
  }, () => {
    // should never append, but even if it does, we don't need to do anything,
    // and will just use the default window confirm instead
  });
  return (message, callback) => {
    if (overlayConfirm) {
      overlayConfirm(message, callback);
    } else {
      fallbackHandler(message, callback);
    }
  };
};
exports.getUserConfirmationHandler = getUserConfirmationHandler;
const windowConfirm = (message, callback) => {
  const confirmed = window.confirm(message);
  callback(confirmed);
};
const getOverlayConfirmHandler = overlay => {
  return (message, callback) => {
    overlay.openConfirm(message, {
      title: ' ',
      'data-test-subj': 'navigationBlockConfirmModal'
    }).then(confirmed => {
      callback(confirmed);
    }, () => {
      callback(false);
    });
  };
};