"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deserializeControlGroup = void 0;
var _lodash = require("lodash");
var _reference_name_utils = require("../../controls/data_controls/reference_name_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const deserializeControlGroup = state => {
  var _state$references;
  const {
    controls
  } = state.rawState;
  const controlsMap = Object.fromEntries(controls.map(({
    id,
    ...rest
  }) => [id, rest]));

  /** Inject data view references into each individual control */
  const references = (_state$references = state.references) !== null && _state$references !== void 0 ? _state$references : [];
  references.forEach(reference => {
    const referenceName = reference.name;
    const {
      controlId
    } = (0, _reference_name_utils.parseReferenceName)(referenceName);
    if (controlsMap[controlId]) {
      controlsMap[controlId].dataViewId = reference.id;
    }
  });

  /** Flatten the state of each control by removing `controlConfig` */
  const flattenedControls = Object.keys(controlsMap).reduce((prev, controlId) => {
    const currentControl = controlsMap[controlId];
    const currentControlExplicitInput = controlsMap[controlId].controlConfig;
    return {
      ...prev,
      [controlId]: {
        ...(0, _lodash.omit)(currentControl, 'controlConfig'),
        ...currentControlExplicitInput
      }
    };
  }, {});
  return {
    ...state.rawState,
    initialChildControlState: flattenedControls
  };
};
exports.deserializeControlGroup = deserializeControlGroup;