"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getControlGroupEmbeddableFactory = void 0;
var _esqlVariablesTypes = require("@kbn/esql-variables-types");
var _i18n = require("@kbn/i18n");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _publishes_reload = require("@kbn/presentation-publishing/interfaces/fetch/publishes_reload");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _common = require("../../common");
var _open_data_control_editor = require("../controls/data_controls/open_data_control_editor");
var _kibana_services = require("../services/kibana_services");
var _control_group = require("./components/control_group");
var _control_fetch = require("./control_fetch");
var _control_group_unsaved_changes_api = require("./control_group_unsaved_changes_api");
var _init_controls_manager = require("./init_controls_manager");
var _open_edit_control_group_flyout = require("./open_edit_control_group_flyout");
var _selections_manager = require("./selections_manager");
var _serialization_utils = require("./utils/serialization_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getControlGroupEmbeddableFactory = () => {
  const controlGroupEmbeddableFactory = {
    type: _common.CONTROL_GROUP_TYPE,
    deserializeState: state => (0, _serialization_utils.deserializeControlGroup)(state),
    buildEmbeddable: async (initialRuntimeState, buildApi, uuid, parentApi, setApi, lastSavedRuntimeState) => {
      const {
        labelPosition: initialLabelPosition,
        chainingSystem,
        autoApplySelections,
        ignoreParentSettings
      } = initialRuntimeState;
      const autoApplySelections$ = new _rxjs.BehaviorSubject(autoApplySelections);
      const defaultDataViewId = await _kibana_services.dataViewsService.getDefaultId();
      const lastSavedControlsState$ = new _rxjs.BehaviorSubject(lastSavedRuntimeState.initialChildControlState);
      const controlsManager = (0, _init_controls_manager.initControlsManager)(initialRuntimeState.initialChildControlState, lastSavedControlsState$);
      const selectionsManager = (0, _selections_manager.initSelectionsManager)({
        ...controlsManager.api,
        autoApplySelections$
      });
      const esqlVariables$ = new _rxjs.BehaviorSubject([]);
      const dataViews$ = new _rxjs.BehaviorSubject(undefined);
      const chainingSystem$ = new _rxjs.BehaviorSubject(chainingSystem !== null && chainingSystem !== void 0 ? chainingSystem : _common.DEFAULT_CONTROL_CHAINING);
      const ignoreParentSettings$ = new _rxjs.BehaviorSubject(ignoreParentSettings);
      const labelPosition$ = new _rxjs.BehaviorSubject(initialLabelPosition !== null && initialLabelPosition !== void 0 ? initialLabelPosition : _common.DEFAULT_CONTROL_LABEL_POSITION);
      const allowExpensiveQueries$ = new _rxjs.BehaviorSubject(true);
      const disabledActionIds$ = new _rxjs.BehaviorSubject(undefined);
      const unsavedChanges = (0, _control_group_unsaved_changes_api.initializeControlGroupUnsavedChanges)(selectionsManager.applySelections, controlsManager.api.children$, {
        ...controlsManager.comparators,
        autoApplySelections: [autoApplySelections$, next => autoApplySelections$.next(next)],
        chainingSystem: [chainingSystem$, next => chainingSystem$.next(next), (a, b) => (a !== null && a !== void 0 ? a : _common.DEFAULT_CONTROL_CHAINING) === (b !== null && b !== void 0 ? b : _common.DEFAULT_CONTROL_CHAINING)],
        ignoreParentSettings: [ignoreParentSettings$, next => ignoreParentSettings$.next(next), _fastDeepEqual.default],
        labelPosition: [labelPosition$, next => labelPosition$.next(next)]
      }, controlsManager.snapshotControlsRuntimeState, controlsManager.resetControlsUnsavedChanges, parentApi, lastSavedRuntimeState);
      const api = setApi({
        ...controlsManager.api,
        esqlVariables$,
        disabledActionIds$,
        ...unsavedChanges.api,
        ...selectionsManager.api,
        controlFetch$: (controlUuid, onReload) => (0, _control_fetch.controlFetch$)((0, _control_fetch.chaining$)(controlUuid, chainingSystem$, controlsManager.controlsInOrder$, controlsManager.api.children$), (0, _control_fetch.controlGroupFetch$)(ignoreParentSettings$, parentApi ? parentApi : {}, onReload)),
        ignoreParentSettings$,
        autoApplySelections$,
        allowExpensiveQueries$,
        snapshotRuntimeState: () => {
          return {
            chainingSystem: chainingSystem$.getValue(),
            labelPosition: labelPosition$.getValue(),
            autoApplySelections: autoApplySelections$.getValue(),
            ignoreParentSettings: ignoreParentSettings$.getValue(),
            initialChildControlState: controlsManager.snapshotControlsRuntimeState()
          };
        },
        onEdit: async () => {
          (0, _open_edit_control_group_flyout.openEditControlGroupFlyout)(api, {
            chainingSystem: chainingSystem$,
            labelPosition: labelPosition$,
            autoApplySelections: autoApplySelections$,
            ignoreParentSettings: ignoreParentSettings$
          });
        },
        isEditingEnabled: () => true,
        openAddDataControlFlyout: settings => {
          var _parentApi$dataViews$, _parentApi$dataViews$2, _ref, _ref2, _newControlState$data;
          const parentDataViewId = (0, _presentationPublishing.apiPublishesDataViews)(parentApi) ? (_parentApi$dataViews$ = parentApi.dataViews$.value) === null || _parentApi$dataViews$ === void 0 ? void 0 : (_parentApi$dataViews$2 = _parentApi$dataViews$[0]) === null || _parentApi$dataViews$2 === void 0 ? void 0 : _parentApi$dataViews$2.id : undefined;
          const newControlState = controlsManager.getNewControlState();
          (0, _open_data_control_editor.openDataControlEditor)({
            initialState: {
              ...newControlState,
              dataViewId: (_ref = (_ref2 = (_newControlState$data = newControlState.dataViewId) !== null && _newControlState$data !== void 0 ? _newControlState$data : parentDataViewId) !== null && _ref2 !== void 0 ? _ref2 : defaultDataViewId) !== null && _ref !== void 0 ? _ref : undefined
            },
            onSave: ({
              type: controlType,
              state: initialState
            }) => {
              var _settings$onSave;
              controlsManager.api.addNewPanel({
                panelType: controlType,
                initialState: settings !== null && settings !== void 0 && settings.controlStateTransform ? settings.controlStateTransform(initialState, controlType) : initialState
              });
              settings === null || settings === void 0 ? void 0 : (_settings$onSave = settings.onSave) === null || _settings$onSave === void 0 ? void 0 : _settings$onSave.call(settings);
            },
            controlGroupApi: api
          });
        },
        serializeState: () => {
          const {
            controls,
            references
          } = controlsManager.serializeControls();
          return {
            rawState: {
              chainingSystem: chainingSystem$.getValue(),
              labelPosition: labelPosition$.getValue(),
              autoApplySelections: autoApplySelections$.getValue(),
              ignoreParentSettings: ignoreParentSettings$.getValue(),
              controls
            },
            references
          };
        },
        dataViews$,
        labelPosition: labelPosition$,
        saveNotification$: (0, _presentationContainers.apiHasSaveNotification)(parentApi) ? parentApi.saveNotification$ : undefined,
        reload$: (0, _publishes_reload.apiPublishesReload)(parentApi) ? parentApi.reload$ : undefined,
        /** Public getters */
        getTypeDisplayName: () => _i18n.i18n.translate('controls.controlGroup.displayName', {
          defaultMessage: 'Controls'
        }),
        getEditorConfig: () => initialRuntimeState.editorConfig,
        getLastSavedControlState: controlUuid => {
          var _lastSavedRuntimeStat;
          return (_lastSavedRuntimeStat = lastSavedRuntimeState.initialChildControlState[controlUuid]) !== null && _lastSavedRuntimeStat !== void 0 ? _lastSavedRuntimeStat : {};
        },
        /** Public setters */
        setDisabledActionIds: ids => disabledActionIds$.next(ids),
        setChainingSystem: newChainingSystem => chainingSystem$.next(newChainingSystem)
      });

      /** Subscribe to all children's output data views, combine them, and output them */
      const childrenDataViewsSubscription = (0, _presentationContainers.combineCompatibleChildrenApis)(api, 'dataViews$', _presentationPublishing.apiPublishesDataViews, []).subscribe(newDataViews => dataViews$.next(newDataViews));

      /** Combine ESQL variables from all children that publish them. */
      const childrenESQLVariablesSubscription = (0, _presentationContainers.combineCompatibleChildrenApis)(api, 'esqlVariable$', _esqlVariablesTypes.apiPublishesESQLVariable, []).subscribe(newESQLVariables => {
        esqlVariables$.next(newESQLVariables);
      });
      const saveNotificationSubscription = (0, _presentationContainers.apiHasSaveNotification)(parentApi) ? parentApi.saveNotification$.subscribe(() => {
        lastSavedControlsState$.next(controlsManager.snapshotControlsRuntimeState());
        if (typeof autoApplySelections$.value === 'boolean' && !autoApplySelections$.value && selectionsManager.hasUnappliedSelections$.value) {
          selectionsManager.applySelections();
        }
      }) : undefined;
      return {
        api,
        Component: () => {
          const [hasUnappliedSelections, labelPosition] = (0, _presentationPublishing.useBatchedPublishingSubjects)(selectionsManager.hasUnappliedSelections$, labelPosition$);
          (0, _react.useEffect)(() => {
            /** Fetch the allowExpensiveQuries setting for the children to use if necessary */
            const fetchAllowExpensiveQueries = async () => {
              try {
                const {
                  allowExpensiveQueries
                } = await _kibana_services.coreServices.http.get('/internal/controls/getExpensiveQueriesSetting', {
                  version: '1'
                });
                if (!allowExpensiveQueries) {
                  // only set if this returns false, since it defaults to true
                  allowExpensiveQueries$.next(allowExpensiveQueries);
                }
              } catch {
                // do nothing - default to true on error (which it was initialized to)
              }
            };
            fetchAllowExpensiveQueries(); // no need to await - don't want to block anything waiting for this

            return () => {
              selectionsManager.cleanup();
              childrenDataViewsSubscription.unsubscribe();
              childrenESQLVariablesSubscription.unsubscribe();
              saveNotificationSubscription === null || saveNotificationSubscription === void 0 ? void 0 : saveNotificationSubscription.unsubscribe();
            };
          }, []);
          return /*#__PURE__*/_react.default.createElement(_control_group.ControlGroup, {
            applySelections: selectionsManager.applySelections,
            controlGroupApi: api,
            controlsManager: controlsManager,
            hasUnappliedSelections: hasUnappliedSelections,
            labelPosition: labelPosition
          });
        }
      };
    }
  };
  return controlGroupEmbeddableFactory;
};
exports.getControlGroupEmbeddableFactory = getControlGroupEmbeddableFactory;