"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _sortable = require("@dnd-kit/sortable");
var _utilities = require("@dnd-kit/utilities");
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _floating_actions = require("./floating_actions");
var _common = require("../../../common");
var _control_error = require("./control_error");
require("./control_panel.scss");
var _is_compressed = require("../utils/is_compressed");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DragHandle = ({
  isEditable,
  controlTitle,
  ...rest // drag info is contained here
}) => isEditable ? /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({}, rest, {
  "aria-label": _i18n.i18n.translate('controls.controlGroup.ariaActions.moveControlButtonAction', {
    defaultMessage: 'Move control {controlTitle}',
    values: {
      controlTitle: controlTitle !== null && controlTitle !== void 0 ? controlTitle : ''
    }
  }),
  className: "controlFrame__dragHandle"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "grabHorizontal"
})) : null;
const ControlPanel = ({
  Component,
  uuid
}) => {
  var _api$parentApi, _api$parentApi2;
  const [api, setApi] = (0, _react.useState)(null);
  const {
    attributes,
    listeners,
    setNodeRef,
    transform,
    transition,
    isOver,
    isDragging,
    index,
    isSorting,
    activeIndex
  } = (0, _sortable.useSortable)({
    id: uuid
  });
  const style = {
    transition,
    transform: isSorting ? undefined : _utilities.CSS.Translate.toString(transform)
  };
  const viewModeSubject = (() => {
    if ((0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiHasParentApi)(api.parentApi) &&
    // api.parentApi => controlGroupApi
    (0, _presentationPublishing.apiPublishesViewMode)(api.parentApi.parentApi) // controlGroupApi.parentApi => dashboardApi
    ) return api.parentApi.parentApi.viewMode$; // get view mode from dashboard API
  })();
  const [dataLoading, blockingError, panelTitle, defaultPanelTitle, grow, width, labelPosition, disabledActionIds, rawViewMode] = (0, _presentationPublishing.useBatchedOptionalPublishingSubjects)(api === null || api === void 0 ? void 0 : api.dataLoading$, api === null || api === void 0 ? void 0 : api.blockingError$, api === null || api === void 0 ? void 0 : api.title$, api === null || api === void 0 ? void 0 : api.defaultTitle$, api === null || api === void 0 ? void 0 : api.grow, api === null || api === void 0 ? void 0 : api.width, api === null || api === void 0 ? void 0 : (_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : _api$parentApi.labelPosition, api === null || api === void 0 ? void 0 : (_api$parentApi2 = api.parentApi) === null || _api$parentApi2 === void 0 ? void 0 : _api$parentApi2.disabledActionIds$, viewModeSubject);
  const usingTwoLineLayout = labelPosition === 'twoLine';
  const controlType = api ? api.type : undefined;
  const [initialLoadComplete, setInitialLoadComplete] = (0, _react.useState)(!dataLoading);
  if (!initialLoadComplete && (dataLoading === false || api && !api.dataLoading$)) {
    setInitialLoadComplete(true);
  }
  const viewMode = rawViewMode !== null && rawViewMode !== void 0 ? rawViewMode : _public.ViewMode.VIEW;
  const isEditable = viewMode === _public.ViewMode.EDIT;
  const controlWidth = width !== null && width !== void 0 ? width : _common.DEFAULT_CONTROL_WIDTH;
  const controlGrow = grow !== null && grow !== void 0 ? grow : _common.DEFAULT_CONTROL_GROW;
  const controlLabel = usingTwoLineLayout ? panelTitle || defaultPanelTitle || '...' : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    ref: setNodeRef,
    style: style,
    grow: controlGrow,
    "data-control-id": uuid,
    "data-test-subj": "control-frame",
    "data-render-complete": "true",
    className: (0, _classnames.default)('controlFrameWrapper', {
      'controlFrameWrapper--small': controlWidth === 'small',
      'controlFrameWrapper--medium': controlWidth === 'medium',
      'controlFrameWrapper--large': controlWidth === 'large',
      'controlFrameWrapper-isDragging': isDragging,
      'controlFrameWrapper--insertBefore': isOver && (index !== null && index !== void 0 ? index : -1) < (activeIndex !== null && activeIndex !== void 0 ? activeIndex : -1),
      'controlFrameWrapper--insertAfter': isOver && (index !== null && index !== void 0 ? index : -1) > (activeIndex !== null && activeIndex !== void 0 ? activeIndex : -1)
    })
  }, /*#__PURE__*/_react.default.createElement(_floating_actions.FloatingActions, {
    api: api,
    className: (0, _classnames.default)({
      'controlFrameFloatingActions--twoLine': usingTwoLineLayout,
      'controlFrameFloatingActions--oneLine': !usingTwoLineLayout
    }),
    viewMode: viewMode,
    disabledActions: disabledActionIds,
    isEnabled: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "control-frame-title",
    fullWidth: true,
    label: controlLabel,
    id: `control-title-${uuid}`,
    "aria-label": `Control for ${controlLabel}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    fullWidth: true,
    isLoading: Boolean(dataLoading),
    className: (0, _classnames.default)('controlFrame__formControlLayout', {
      'controlFrame__formControlLayout--twoLine': usingTwoLineLayout,
      'controlFrame__formControlLayout--edit': isEditable
    }, `${controlType}`),
    prepend: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(DragHandle, (0, _extends2.default)({
      isEditable: isEditable,
      controlTitle: panelTitle || defaultPanelTitle
    }, attributes, listeners)), api !== null && api !== void 0 && api.CustomPrependComponent ? /*#__PURE__*/_react.default.createElement(api.CustomPrependComponent, null) : usingTwoLineLayout ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      anchorClassName: "controlPanel--labelWrapper",
      content: panelTitle || defaultPanelTitle
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      className: "controlPanel--label"
    }, panelTitle || defaultPanelTitle))),
    compressed: (0, _is_compressed.isCompressed)(api)
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, blockingError && /*#__PURE__*/_react.default.createElement(_control_error.ControlError, {
    error: blockingError !== null && blockingError !== void 0 ? blockingError : _i18n.i18n.translate('controls.blockingError', {
      defaultMessage: 'There was an error loading this control.'
    })
  }), /*#__PURE__*/_react.default.createElement(Component, {
    className: (0, _classnames.default)('controlPanel', {
      'controlPanel--roundedBorders': !(api !== null && api !== void 0 && api.CustomPrependComponent) && !isEditable && usingTwoLineLayout,
      'controlPanel--hideComponent': Boolean(blockingError) // don't want to unmount component on error; just hide it
    }),
    ref: newApi => {
      if (newApi && !api) setApi(newApi);
    }
  }))))));
};
exports.ControlPanel = ControlPanel;