"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerControlFactory = exports.getControlFactory = exports.getAllControlTypes = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registry = {};
const registerControlFactory = (type, getFactory) => {
  if (registry[type] !== undefined) throw new Error(_i18n.i18n.translate('controls.controlFactoryRegistry.factoryAlreadyExistsError', {
    defaultMessage: 'A control factory for type: {key} is already registered.',
    values: {
      key: type
    }
  }));
  registry[type] = getFactory;
};
exports.registerControlFactory = registerControlFactory;
const getControlFactory = async key => {
  if (registry[key] === undefined) throw new Error(_i18n.i18n.translate('controls.controlFactoryRegistry.factoryNotFoundError', {
    defaultMessage: 'No control factory found for type: {key}',
    values: {
      key
    }
  }));
  return await registry[key]();
};
exports.getControlFactory = getControlFactory;
const getAllControlTypes = () => {
  return Object.keys(registry);
};
exports.getAllControlTypes = getAllControlTypes;