"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRemediationList = exports.OverviewTab = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _use_data_view = require("@kbn/cloud-security-posture/src/hooks/use_data_view");
var _get_vendor_name = require("../../../common/utils/get_vendor_name");
var _helpers = require("../../../../common/utils/helpers");
var _constants = require("../../../common/constants");
var _constants2 = require("../../../../common/constants");
var _use_kibana = require("../../../common/hooks/use_kibana");
var _findings_flyout = require("./findings_flyout");
var _findings_detection_rule_counter = require("./findings_detection_rule_counter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDetailsList = (data, ruleFlyoutLink, discoverDataViewLink) => {
  var _data$rule, _data$rule2, _data$rule2$tags, _data$rule3, _data$rule3$benchmark, _data$rule4, _data$rule4$benchmark, _data$rule5, _data$rule5$benchmark, _data$rule6, _data$rule6$benchmark, _data$rule7, _data$rule8;
  return [{
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.ruleNameTitle', {
      defaultMessage: 'Rule Name'
    }),
    description: (_data$rule = data.rule) !== null && _data$rule !== void 0 && _data$rule.name ? /*#__PURE__*/_react.default.createElement(_findings_flyout.RuleNameLink, {
      ruleFlyoutLink: ruleFlyoutLink,
      ruleName: data.rule.name
    }) : _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.alertsTitle', {
      defaultMessage: 'Alerts'
    }),
    description: /*#__PURE__*/_react.default.createElement(_findings_detection_rule_counter.FindingsDetectionRuleCounter, {
      finding: data
    })
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.ruleTagsTitle', {
      defaultMessage: 'Rule Tags'
    }),
    description: (_data$rule2 = data.rule) !== null && _data$rule2 !== void 0 && (_data$rule2$tags = _data$rule2.tags) !== null && _data$rule2$tags !== void 0 && _data$rule2$tags.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.rule.tags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      key: tag
    }, tag))) : _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.evaluatedAtTitle', {
      defaultMessage: 'Evaluated at'
    }),
    description: data['@timestamp'] ? (0, _moment.default)(data['@timestamp']).format(_constants.CSP_MOMENT_FORMAT) : _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.frameworkSourcesTitle', {
      defaultMessage: 'Framework Sources'
    }),
    description: (_data$rule3 = data.rule) !== null && _data$rule3 !== void 0 && (_data$rule3$benchmark = _data$rule3.benchmark) !== null && _data$rule3$benchmark !== void 0 && _data$rule3$benchmark.id && (_data$rule4 = data.rule) !== null && _data$rule4 !== void 0 && (_data$rule4$benchmark = _data$rule4.benchmark) !== null && _data$rule4$benchmark !== void 0 && _data$rule4$benchmark.name ? /*#__PURE__*/_react.default.createElement(_findings_flyout.BenchmarkIcons, {
      benchmarkId: (_data$rule5 = data.rule) === null || _data$rule5 === void 0 ? void 0 : (_data$rule5$benchmark = _data$rule5.benchmark) === null || _data$rule5$benchmark === void 0 ? void 0 : _data$rule5$benchmark.id,
      benchmarkName: (_data$rule6 = data.rule) === null || _data$rule6 === void 0 ? void 0 : (_data$rule6$benchmark = _data$rule6.benchmark) === null || _data$rule6$benchmark === void 0 ? void 0 : _data$rule6$benchmark.name
    }) : _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.cisSectionTitle', {
      defaultMessage: 'Framework Section'
    }),
    description: (_data$rule7 = data.rule) !== null && _data$rule7 !== void 0 && _data$rule7.section ? (_data$rule8 = data.rule) === null || _data$rule8 === void 0 ? void 0 : _data$rule8.section : _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.vendorTitle', {
      defaultMessage: 'Vendor'
    }),
    description: (0, _get_vendor_name.getVendorName)(data) || _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.dataViewTitle', {
      defaultMessage: 'Data View'
    }),
    description: discoverDataViewLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: discoverDataViewLink
    }, _cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_INDEX_PATTERN) : _cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_INDEX_PATTERN
  }];
};
const getRemediationList = rule => [{
  title: '',
  description: rule !== null && rule !== void 0 && rule.remediation ? /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule === null || rule === void 0 ? void 0 : rule.remediation) : _findings_flyout.EMPTY_VALUE
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.impactTitle', {
    defaultMessage: 'Impact'
  }),
  description: rule !== null && rule !== void 0 && rule.impact ? /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.impact) : _findings_flyout.EMPTY_VALUE
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.defaultValueTitle', {
    defaultMessage: 'Default Value'
  }),
  description: rule !== null && rule !== void 0 && rule.default_value ? /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.default_value) : _findings_flyout.EMPTY_VALUE
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.rationaleTitle', {
    defaultMessage: 'Rationale'
  }),
  description: rule !== null && rule !== void 0 && rule.rationale ? /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.rationale) : _findings_flyout.EMPTY_VALUE
}];
exports.getRemediationList = getRemediationList;
const getEvidenceList = ({
  result
}) => [{
  title: '',
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findings.findingsFlyout.overviewTab.evidenceDescription",
    defaultMessage: "The specific resource metadata that was evaluated to generate this posture finding"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), /*#__PURE__*/_react.default.createElement(_findings_flyout.CodeBlock, {
    language: "json"
  }, JSON.stringify(result === null || result === void 0 ? void 0 : result.evidence, null, 2)))
}].filter(_helpers.truthy);
const OverviewTab = ({
  data,
  ruleFlyoutLink
}) => {
  var _data$data_stream2, _cdrMisconfigurations2, _data$result;
  const {
    discover
  } = (0, _use_kibana.useKibana)().services;
  const cdrMisconfigurationsDataView = (0, _use_data_view.useDataView)(_cloudSecurityPostureCommon.CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX);

  // link will navigate to our dataview in discover, filtered by the data source of the finding
  const discoverDataViewLink = (0, _react.useMemo)(() => {
    var _discover$locator, _cdrMisconfigurations, _data$data_stream;
    return (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.getRedirectUrl({
      dataViewId: (_cdrMisconfigurations = cdrMisconfigurationsDataView.data) === null || _cdrMisconfigurations === void 0 ? void 0 : _cdrMisconfigurations.id,
      ...(((_data$data_stream = data.data_stream) === null || _data$data_stream === void 0 ? void 0 : _data$data_stream.dataset) && {
        filters: [{
          meta: {
            type: 'phrase',
            key: 'data_stream.dataset'
          },
          query: {
            match_phrase: {
              'data_stream.dataset': data.data_stream.dataset
            }
          }
        }]
      })
    });
  }, [(_data$data_stream2 = data.data_stream) === null || _data$data_stream2 === void 0 ? void 0 : _data$data_stream2.dataset, discover.locator, (_cdrMisconfigurations2 = cdrMisconfigurationsDataView.data) === null || _cdrMisconfigurations2 === void 0 ? void 0 : _cdrMisconfigurations2.id]);
  const hasEvidence = !(0, _lodash.isEmpty)((_data$result = data.result) === null || _data$result === void 0 ? void 0 : _data$result.evidence);
  const accordions = (0, _react.useMemo)(() => [{
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.detailsTitle', {
      defaultMessage: 'Details'
    }),
    id: 'detailsAccordion',
    listItems: getDetailsList(data, ruleFlyoutLink, discoverDataViewLink)
  }, {
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.remediationTitle', {
      defaultMessage: 'Remediation'
    }),
    id: 'remediationAccordion',
    listItems: getRemediationList(data.rule)
  }, _constants2.INTERNAL_FEATURE_FLAGS.showFindingFlyoutEvidence && hasEvidence && {
    initialIsOpen: true,
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.overviewTab.evidenceSourcesTitle', {
      defaultMessage: 'Evidence'
    }),
    id: 'evidenceAccordion',
    listItems: getEvidenceList(data)
  }].filter(_helpers.truthy), [data, discoverDataViewLink, hasEvidence, ruleFlyoutLink]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, accordions.map(accordion => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: accordion.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordion.id,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, accordion.title)),
    arrowDisplay: "left",
    initialIsOpen: accordion.initialIsOpen
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: accordion.listItems
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))));
};
exports.OverviewTab = OverviewTab;