"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudFullStoryPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _moment = require("moment");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class CloudFullStoryPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
  }
  setup(core, {
    cloud
  }) {
    if (cloud.isCloudEnabled) {
      if (cloud.isElasticStaffOwned) {
        this.initializerContext.logger.get().info('Skipping FullStory setup for a Elastic-owned deployments');
        return;
      }
      this.setupFullStory({
        analytics: core.analytics,
        basePath: core.http.basePath
      }).catch(e =>
      // eslint-disable-next-line no-console
      console.debug(`Error setting up FullStory: ${e.toString()}`));
    }
  }
  start() {}
  stop() {}

  /**
   * If the right config is provided, register the FullStory shipper to the analytics client.
   * @param analytics Core's Analytics service's setup contract.
   * @param basePath Core's http.basePath helper.
   * @private
   */
  async setupFullStory({
    analytics,
    basePath
  }) {
    const {
      org_id: fullStoryOrgId,
      eventTypesAllowlist,
      pageVarsDebounceTime
    } = this.config;
    if (!fullStoryOrgId) {
      return; // do not load any FullStory code in the browser if not enabled
    }

    // Keep this import async so that we do not load any FullStory code into the browser when it is disabled.
    const {
      FullStoryShipper
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('@elastic/ebt/shippers/fullstory')));
    analytics.registerShipper(FullStoryShipper, {
      eventTypesAllowlist,
      fullStoryOrgId,
      // Duration configs get stringified when forwarded to the UI and need reconversion
      ...(pageVarsDebounceTime ? {
        pageVarsDebounceTimeMs: (0, _moment.duration)(pageVarsDebounceTime).asMilliseconds()
      } : {}),
      /**
       * FIXME: this should use the {@link IStaticAssets['getPluginAssetHref']}
       * function. Then we can avoid registering our own endpoint in this plugin.
       */
      scriptUrl: basePath.prepend(`/internal/cloud/${this.initializerContext.env.packageInfo.buildNum}/fullstory.js`),
      namespace: 'FSKibana',
      // Tell FullStory to not capture from the start, and wait for the opt-in confirmation
      captureOnStartup: false
    });
  }
}
exports.CloudFullStoryPlugin = CloudFullStoryPlugin;