"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.urlValidator = exports.normalizeValueType = exports.ipv6Validator = exports.ipv4Validator = exports.genericValidator = exports.fieldsConfig = exports.emailValidator = exports.domainValidator = void 0;
var _emailAddresses = require("email-addresses");
var _ipaddr = _interopRequireDefault(require("ipaddr.js"));
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const normalizeValueType = value => {
  if (value in fieldsConfig.value) {
    return value;
  }
  return 'generic';
};
exports.normalizeValueType = normalizeValueType;
const DOMAIN_REGEX = /^(?!-)[A-Za-z0-9-]{1,63}(?<!-)\.[A-Za-z]{2,}$/;
const GENERIC_REGEX = /^[a-zA-Z0-9._:/\\-]+$/;
const notStringError = path => ({
  code: 'ERR_NOT_STRING',
  message: 'Value should be a string',
  path
});
const {
  emptyField
} = _helpers.fieldValidators;
const validatorFactory = (regex, message = i18n.INVALID_VALUE, code = 'ERR_NOT_VALID') => (...args) => {
  const [{
    value,
    path
  }] = args;
  if (typeof value !== 'string') {
    return notStringError(path);
  }
  if (!regex.test(value)) {
    return {
      code,
      message,
      path
    };
  }
};
const genericValidator = exports.genericValidator = validatorFactory(GENERIC_REGEX);
const domainValidator = exports.domainValidator = validatorFactory(DOMAIN_REGEX);
const ipValidatorFactory = kind => (...args) => {
  const [{
    value,
    path
  }] = args;
  if (typeof value !== 'string') {
    return notStringError(path);
  }
  try {
    const parsed = _ipaddr.default.parse(value);
    if (parsed.kind() !== kind) {
      return {
        code: 'ERR_NOT_VALID',
        message: i18n.INVALID_VALUE,
        path
      };
    }
  } catch (error) {
    return {
      code: 'ERR_NOT_VALID',
      message: i18n.INVALID_VALUE,
      path
    };
  }
};
const ipv6Validator = exports.ipv6Validator = ipValidatorFactory('ipv6');
const ipv4Validator = exports.ipv4Validator = ipValidatorFactory('ipv4');
const urlValidator = (...args) => {
  const [{
    value,
    path
  }] = args;
  if (typeof value !== 'string') {
    return notStringError(path);
  }
  try {
    new URL(value);
  } catch (error) {
    return {
      code: 'ERR_NOT_VALID',
      message: i18n.INVALID_VALUE,
      path
    };
  }
};
exports.urlValidator = urlValidator;
const emailValidator = (...args) => {
  const [{
    value,
    path
  }] = args;
  if (typeof value !== 'string') {
    return notStringError(path);
  }
  const emailAddresses = (0, _emailAddresses.parseAddressList)(value);
  if (emailAddresses == null) {
    return {
      message: i18n.INVALID_EMAIL,
      code: 'ERR_NOT_EMAIL',
      path
    };
  }
};
exports.emailValidator = emailValidator;
const fieldsConfig = exports.fieldsConfig = {
  value: {
    generic: {
      validations: [{
        validator: emptyField(i18n.REQUIRED_VALUE)
      }, {
        validator: genericValidator
      }],
      label: i18n.FIELD_LABEL_VALUE
    },
    [_constants.OBSERVABLE_TYPE_EMAIL.key]: {
      validations: [{
        validator: emptyField(i18n.REQUIRED_VALUE)
      }, {
        validator: emailValidator
      }],
      label: 'Email'
    },
    [_constants.OBSERVABLE_TYPE_DOMAIN.key]: {
      validations: [{
        validator: emptyField(i18n.REQUIRED_VALUE)
      }, {
        validator: domainValidator
      }],
      label: 'Domain'
    },
    [_constants.OBSERVABLE_TYPE_IPV4.key]: {
      validations: [{
        validator: emptyField(i18n.REQUIRED_VALUE)
      }, {
        validator: ipv4Validator
      }],
      label: 'IPv4'
    },
    [_constants.OBSERVABLE_TYPE_IPV6.key]: {
      validations: [{
        validator: emptyField(i18n.REQUIRED_VALUE)
      }, {
        validator: ipv6Validator
      }],
      label: 'IPv6'
    },
    [_constants.OBSERVABLE_TYPE_URL.key]: {
      validations: [{
        validator: emptyField(i18n.REQUIRED_VALUE)
      }, {
        validator: urlValidator
      }],
      label: 'URL'
    }
  },
  typeKey: {
    validations: [{
      validator: emptyField(i18n.REQUIRED_VALUE)
    }],
    label: i18n.FIELD_LABEL_TYPE
  },
  description: {
    label: i18n.FIELD_LABEL_DESCRIPTION
  }
};