"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActionFindResponseRt = exports.UserActionFindRequestRt = exports.CaseUserActionsDeprecatedResponseRt = exports.CaseUserActionStatsRt = exports.CaseUserActionStatsResponseRt = exports.CaseUserActionDeprecatedResponseRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _schema = require("../../../schema");
var _constants = require("../../../constants");
var _v = require("../../domain/user_action/action/v1");
var _v2 = require("../../domain/user_action/v1");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * User actions stats API
 */
const CaseUserActionStatsRt = exports.CaseUserActionStatsRt = rt.strict({
  total: rt.number,
  total_deletions: rt.number,
  total_comments: rt.number,
  total_comment_deletions: rt.number,
  total_other_actions: rt.number,
  total_other_action_deletions: rt.number
});
const CaseUserActionStatsResponseRt = exports.CaseUserActionStatsResponseRt = CaseUserActionStatsRt;

/**
 * Deprecated APIs
 */
const CaseUserActionDeprecatedResponseRt = exports.CaseUserActionDeprecatedResponseRt = rt.intersection([_v2.CaseUserActionBasicRt, _v2.CaseUserActionInjectedDeprecatedIdsRt]);
const CaseUserActionsDeprecatedResponseRt = exports.CaseUserActionsDeprecatedResponseRt = rt.array(CaseUserActionDeprecatedResponseRt);
/**
 * Find User Actions API
 */

const UserActionAdditionalFindRequestFilterTypes = {
  action: 'action',
  alert: 'alert',
  user: 'user',
  attachment: 'attachment'
};
const UserActionFindRequestTypes = {
  ..._v.UserActionTypes,
  ...UserActionAdditionalFindRequestFilterTypes
};
const UserActionFindRequestTypesRt = rt.keyof(UserActionFindRequestTypes);
const UserActionFindRequestRt = exports.UserActionFindRequestRt = rt.intersection([rt.exact(rt.partial({
  types: rt.array(UserActionFindRequestTypesRt),
  sortOrder: rt.union([rt.literal('desc'), rt.literal('asc')])
})), (0, _schema.paginationSchema)({
  maxPerPage: _constants.MAX_USER_ACTIONS_PER_PAGE
})]);
const UserActionFindResponseRt = exports.UserActionFindResponseRt = rt.strict({
  userActions: _v2.UserActionsRt,
  page: rt.number,
  perPage: rt.number,
  total: rt.number
});