"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadRoute = exports.WorkpadHistoryManager = exports.ExportWorkpadRoute = exports.ExportRouteManager = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRedux = require("react-redux");
var _workpad_app = require("../../components/workpad_app");
var _export_app = require("../../components/export_app");
var _canvas_loading = require("../../components/canvas_loading");
var _elements = require("../../state/actions/elements");
var _services = require("../../services");
var _i18n = require("../../../i18n");
var _use_workpad = require("./hooks/use_workpad");
var _use_restore_history = require("./hooks/use_restore_history");
var _use_workpad_history = require("./hooks/use_workpad_history");
var _use_page_sync = require("./hooks/use_page_sync");
var _use_workpad_persist = require("./hooks/use_workpad_persist");
var _workpad_routing_context = require("./workpad_routing_context");
var _workpad_presentation_helper = require("./workpad_presentation_helper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

const {
  workpadRoutes: strings
} = _i18n.ErrorStrings;
const WorkpadRoute = () => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ['/workpad/:id/page/:pageNumber', '/workpad/:id'],
    exact: false
    // @ts-expect-error @types/react@18 - match can be null
    ,
    children: route => {
      return /*#__PURE__*/_react.default.createElement(WorkpadRouteComponent, {
        route: route
      });
    }
  });
};
exports.WorkpadRoute = WorkpadRoute;
const WorkpadRouteComponent = ({
  route
}) => {
  const getRedirectPath = (0, _react.useCallback)(workpadId => `/workpad/${workpadId}${route.match.params.pageNumber ? `/page/${route.match.params.pageNumber}` : ''}`, [route.match.params.pageNumber]);
  return /*#__PURE__*/_react.default.createElement(WorkpadLoaderComponent, {
    params: route.match.params,
    key: "workpad-loader",
    getRedirectPath: getRedirectPath
  }, workpad => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/workpad/:id/page/:pageNumber",
    children: pageRoute => /*#__PURE__*/_react.default.createElement(WorkpadHistoryManager, null, /*#__PURE__*/_react.default.createElement(_workpad_routing_context.WorkpadRoutingContextComponent, null, /*#__PURE__*/_react.default.createElement(_workpad_presentation_helper.WorkpadPresentationHelper, null, /*#__PURE__*/_react.default.createElement(_workpad_app.WorkpadApp, null))))
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/workpad/:id",
    strict: false,
    exact: true
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: `/workpad/${route.match.params.id}/page/${workpad.page + 1}`
  }))));
};
const ExportWorkpadRoute = () => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/export/workpad/pdf/:id/page/:pageNumber'
    // @ts-expect-error @types/react@18 - match can be null
    ,
    children: route => {
      return /*#__PURE__*/_react.default.createElement(ExportWorkpadRouteComponent, {
        route: route
      });
    }
  });
};
exports.ExportWorkpadRoute = ExportWorkpadRoute;
const ExportWorkpadRouteComponent = ({
  route: {
    match
  }
}) => {
  const getRedirectPath = (0, _react.useCallback)(workpadId => `/export/workpad/pdf/${workpadId}/page/${match.params.pageNumber}`, [match.params.pageNumber]);
  return /*#__PURE__*/_react.default.createElement(WorkpadLoaderComponent, {
    loadPages: false,
    params: match.params,
    getRedirectPath: getRedirectPath
  }, () => /*#__PURE__*/_react.default.createElement(ExportRouteManager, null, /*#__PURE__*/_react.default.createElement(_export_app.ExportApp, null)));
};
const ExportRouteManager = ({
  children
}) => {
  const params = (0, _reactRouterDom.useParams)();
  (0, _use_page_sync.usePageSync)();
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch((0, _elements.fetchAllRenderables)({
      onlyActivePage: true
    }));
  }, [dispatch, params.pageNumber]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
exports.ExportRouteManager = ExportRouteManager;
const WorkpadHistoryManager = ({
  children
}) => {
  (0, _use_restore_history.useRestoreHistory)();
  (0, _use_workpad_history.useWorkpadHistory)();
  (0, _use_page_sync.usePageSync)();
  (0, _use_workpad_persist.useWorkpadPersist)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
exports.WorkpadHistoryManager = WorkpadHistoryManager;
const WorkpadLoaderComponent = ({
  params,
  children,
  loadPages,
  getRedirectPath
}) => {
  const [workpad, error] = (0, _use_workpad.useWorkpad)(params.id, loadPages, getRedirectPath);
  const notifyService = (0, _services.useNotifyService)();
  (0, _react.useEffect)(() => {
    if (error) {
      notifyService.error(error, {
        title: strings.getLoadFailureErrorMessage()
      });
    }
  }, [error, notifyService]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: "/"
    });
  }
  if (!workpad) {
    return /*#__PURE__*/_react.default.createElement(_canvas_loading.CanvasLoading, null);
  }
  return children(workpad);
};