"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asset = asset;
var _store = require("../state/store");
var _assets = require("../state/selectors/assets");
var _i18n = require("../../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error unconverted local lib

function asset() {
  const {
    help,
    args: argHelp
  } = (0, _i18n.getFunctionHelp)().asset;
  const errors = (0, _i18n.getFunctionErrors)().asset;
  return {
    name: 'asset',
    aliases: [],
    type: 'string',
    inputTypes: ['null'],
    help,
    args: {
      id: {
        aliases: ['_'],
        types: ['string'],
        help: argHelp.id,
        required: true
      }
    },
    fn: (input, args) => {
      const assetId = args.id;
      const storedAsset = (0, _assets.getAssetById)((0, _store.getState)(), assetId);
      if (storedAsset !== undefined) {
        return storedAsset.value;
      }
      throw errors.invalidAssetId(assetId);
    }
  };
}