"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetAppContext = useGetAppContext;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _lib = require("../../../common/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetAppContext(core) {
  const currentAppId = (0, _useObservable.default)(core.application.currentAppId$, undefined);
  const getAppContext = (0, _react.useMemo)(() => {
    return () => ({
      getCurrentPath: () => {
        const urlToApp = core.application.getUrlForApp(currentAppId !== null && currentAppId !== void 0 ? currentAppId : _lib.CANVAS_APP);
        const inAppPath = window.location.pathname.replace(urlToApp, '');
        return inAppPath + window.location.search + window.location.hash;
      },
      currentAppId: _lib.CANVAS_APP
    });
  }, [currentAppId, core.application]);
  return getAppContext;
}