"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSampleChartSelection = useSampleChartSelection;
var _reactRouterDom = require("react-router-dom");
var _url_helpers = require("../components/shared/links/url_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSampleChartSelection() {
  const history = (0, _reactRouterDom.useHistory)();
  const selectSampleFromChartSelection = selection => {
    if (selection !== undefined) {
      const {
        x
      } = selection;
      if (Array.isArray(x)) {
        (0, _url_helpers.push)(history, {
          query: {
            sampleRangeFrom: Math.round(x[0]).toString(),
            sampleRangeTo: Math.round(x[1]).toString()
          }
        });
      }
    }
  };
  const clearChartSelection = () => {
    // enforces a reset of the current sample to be highlighted in the chart
    // and selected in waterfall section below, otherwise we end up with
    // stale data for the selected sample
    (0, _url_helpers.push)(history, {
      query: {
        sampleRangeFrom: '',
        sampleRangeTo: '',
        traceId: '',
        transactionId: ''
      }
    });
  };
  return {
    selectSampleFromChartSelection,
    clearChartSelection
  };
}