"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransactionBreakdown = useTransactionBreakdown;
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTransactionBreakdown({
  kuery,
  environment
}) {
  const {
    urlParams: {
      transactionName
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}', '/mobile-services/{serviceName}');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    transactionType,
    serviceName,
    transactionTypeStatus
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    data = {
      timeseries: undefined
    },
    error,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!transactionType && transactionTypeStatus === _use_fetcher.FETCH_STATUS.SUCCESS) {
      return Promise.resolve({
        timeseries: undefined
      });
    }
    if (serviceName && start && end && transactionType) {
      return callApmApi('GET /internal/apm/services/{serviceName}/transaction/charts/breakdown', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            transactionName,
            transactionType
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end, transactionType, transactionTypeStatus, transactionName]);
  return {
    data,
    status,
    error
  };
}