"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SparkPlot = SparkPlot;
exports.SparkPlotItem = SparkPlotItem;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _style = require("../../../../utils/style");
var _get_comparison_chart_theme = require("../../time_comparison/get_comparison_chart_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function hasValidTimeseries(series) {
  return !!(series !== null && series !== void 0 && series.some(point => point.y !== null));
}
const flexGroupStyle = {
  overflow: 'hidden'
};
function SparkPlot({
  type = 'line',
  color,
  isLoading,
  series,
  comparisonSeries = [],
  valueLabel,
  compact,
  comparisonSeriesColor
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "xs",
    responsive: false,
    alignItems: "flexEnd",
    style: flexGroupStyle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, valueLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(SparkPlotItem, {
    type: type,
    color: color,
    isLoading: isLoading,
    series: series,
    comparisonSeries: comparisonSeries,
    comparisonSeriesColor: comparisonSeriesColor,
    compact: compact
  })));
}
function SparkPlotItem({
  type,
  color,
  isLoading,
  series,
  comparisonSeries,
  comparisonSeriesColor,
  compact
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const defaultChartThemes = (0, _public.useChartThemes)();
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  const hasComparisonSeries = !!(comparisonSeries !== null && comparisonSeries !== void 0 && comparisonSeries.length);
  const sparkplotChartTheme = {
    chartMargins: {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    },
    lineSeriesStyle: {
      point: {
        opacity: 0
      }
    },
    areaSeriesStyle: {
      point: {
        opacity: 0
      }
    },
    ...(hasComparisonSeries ? comparisonChartTheme : {})
  };
  const chartSize = {
    height: euiTheme.size.l,
    width: compact ? _style.unit * 4 : _style.unit * 5
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        ...chartSize,
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null));
  }
  if (hasValidTimeseries(series)) {
    return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
      size: chartSize
    }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
      theme: [sparkplotChartTheme, ...defaultChartThemes.theme],
      baseTheme: defaultChartThemes.baseTheme,
      showLegend: false,
      locale: _i18n.i18n.getLocale()
    }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
      type: "none"
    }), type && type === 'bar' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
      id: "barSeries",
      xScaleType: _charts.ScaleType.Linear,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: "x",
      yAccessors: ['y'],
      data: series,
      color: color
    }), hasComparisonSeries && /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
      id: "comparisonBarSeries",
      xScaleType: _charts.ScaleType.Linear,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: 'x',
      yAccessors: ['y'],
      data: comparisonSeries,
      color: comparisonSeriesColor
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
      id: "Sparkline",
      xScaleType: _charts.ScaleType.Time,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: 'x',
      yAccessors: ['y'],
      data: series,
      color: color,
      curve: _charts.CurveType.CURVE_MONOTONE_X
    }), hasComparisonSeries && /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
      id: "comparisonSeries",
      xScaleType: _charts.ScaleType.Time,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: 'x',
      yAccessors: ['y'],
      data: comparisonSeries,
      color: comparisonSeriesColor,
      curve: _charts.CurveType.CURVE_MONOTONE_X
    })));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      ...chartSize,
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "visLine",
    color: euiTheme.colors.mediumShade
  }));
}