"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobsListStatus = JobsListStatus;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/ml-plugin/common");
var _mlmanage_jobs_link = require("../../../shared/links/machine_learning_links/mlmanage_jobs_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function JobsListStatus({
  jobId,
  jobState,
  datafeedState,
  version
}) {
  const jobIsOk = jobState === _common.JOB_STATE.OPENED || jobState === _common.JOB_STATE.OPENING;
  const datafeedIsOk = datafeedState === _common.DATAFEED_STATE.STARTED || datafeedState === _common.DATAFEED_STATE.STARTING;
  const isClosed = jobState === _common.JOB_STATE.CLOSED || jobState === _common.JOB_STATE.CLOSING;
  const isLegacy = version < 3;
  const statuses = [];
  if (jobIsOk && datafeedIsOk) {
    statuses.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "success"
    }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.okStatusLabel', {
      defaultMessage: 'OK'
    })));
  } else if (!isClosed) {
    statuses.push(/*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.warningStatusLabel', {
        defaultMessage: 'Job might be experiencing problems. Click the Manage Jobs link to learn more.'
      })
    }, /*#__PURE__*/_react.default.createElement(_mlmanage_jobs_link.MLManageJobsLink, {
      jobId: jobId
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning"
    }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.warningStatusBadgeLabel', {
      defaultMessage: 'Warning'
    })))));
  }
  if (isClosed) {
    statuses.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.closedStatusLabel', {
      defaultMessage: 'Closed'
    })));
  }
  if (isLegacy) {
    statuses.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "default"
    }, ' ', _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.legacyStatusLabel', {
      defaultMessage: 'Legacy'
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, statuses.map((status, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: idx
  }, status)));
}