"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyDashboards = EmptyDashboards;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedSvg = require("@kbn/shared-svg");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmptyDashboards({
  actions
}) {
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    hasShadow: false,
    hasBorder: false,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: colorMode === 'DARK' ? _sharedSvg.dashboardsDark : _sharedSvg.dashboardsLight,
      alt: ""
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serviceDashboards.emptyTitle', {
      defaultMessage: 'The best way to understand your data is to visualize it.'
    })),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.apm.serviceDashboards.emptyBody.first', {
      defaultMessage: 'bring clarity to your data'
    })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.apm.serviceDashboards.emptyBody.second', {
      defaultMessage: 'tell a story about your data'
    })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.apm.serviceDashboards.emptyBody', {
      defaultMessage: 'focus on only the data that’s important to you'
    }))), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.serviceDashboards.emptyBody.getStarted', {
      defaultMessage: 'To get started, add your dashboard'
    }))),
    actions: actions
  }));
}