"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfraOverview = InfraOverview;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _get_signal_type = require("../../../utils/get_signal_type");
var _infra_tabs = require("./infra_tabs");
var _service_tab_empty_state = require("../service_tab_empty_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InfraOverview() {
  const {
    serviceEntitySummary
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const hasLogsOnlySignal = (serviceEntitySummary === null || serviceEntitySummary === void 0 ? void 0 : serviceEntitySummary.dataStreamTypes) && (0, _get_signal_type.isLogsOnlySignal)(serviceEntitySummary.dataStreamTypes);
  if (hasLogsOnlySignal) {
    return /*#__PURE__*/_react.default.createElement(_service_tab_empty_state.ServiceTabEmptyState, {
      id: "infraOverview"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_infra_tabs.InfraTabs, null));
}