"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unmuteAllRuleRoute = void 0;
var _lib = require("../../../../lib");
var _lib2 = require("../../../lib");
var _types = require("../../../../types");
var _unmute_all = require("../../../../../common/routes/rule/apis/unmute_all");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const unmuteAllRuleRoute = (router, licenseState) => {
  router.post({
    path: `${_types.BASE_ALERTING_API_PATH}/rule/{id}/_unmute_all`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'public',
      summary: `Unmute all alerts`,
      tags: ['oas-tag:alerting']
    },
    validate: {
      request: {
        params: _unmute_all.unmuteAllRuleRequestParamsSchemaV1
      },
      response: {
        204: {
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema or parameters.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        },
        404: {
          description: 'Indicates a rule with the given ID does not exist.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const params = req.params;
    try {
      await rulesClient.unmuteAll(params);
      return res.noContent();
    } catch (e) {
      if (e instanceof _lib.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.unmuteAllRuleRoute = unmuteAllRuleRoute;