"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformFindRulesInternalBody = exports.transformFindRulesBody = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformFindRulesBody = params => {
  const {
    per_page: perPage,
    page,
    search,
    default_search_operator: defaultSearchOperator,
    search_fields: searchFields,
    sort_field: sortField,
    sort_order: sortOrder,
    has_reference: hasReference,
    fields,
    filter,
    filter_consumers: filterConsumers
  } = params;
  return {
    ...(page ? {
      page
    } : {}),
    ...(search ? {
      search
    } : {}),
    ...(fields ? {
      fields
    } : {}),
    ...(filter ? {
      filter
    } : {}),
    ...(defaultSearchOperator ? {
      defaultSearchOperator
    } : {}),
    ...(perPage ? {
      perPage
    } : {}),
    ...(sortField ? {
      sortField
    } : {}),
    ...(sortOrder ? {
      sortOrder
    } : {}),
    ...(hasReference ? {
      hasReference
    } : {}),
    ...(searchFields ? {
      searchFields: Array.isArray(searchFields) ? searchFields : [searchFields]
    } : {}),
    ...(filterConsumers ? {
      consumers: filterConsumers
    } : {})
  };
};
exports.transformFindRulesBody = transformFindRulesBody;
const transformFindRulesInternalBody = params => {
  const {
    per_page: perPage,
    page,
    search,
    default_search_operator: defaultSearchOperator,
    search_fields: searchFields,
    sort_field: sortField,
    sort_order: sortOrder,
    has_reference: hasReference,
    fields,
    filter,
    rule_type_ids: ruleTypeIds,
    consumers
  } = params;
  return {
    ...(page ? {
      page
    } : {}),
    ...(search ? {
      search
    } : {}),
    ...(fields ? {
      fields
    } : {}),
    ...(filter ? {
      filter
    } : {}),
    ...(defaultSearchOperator ? {
      defaultSearchOperator
    } : {}),
    ...(perPage ? {
      perPage
    } : {}),
    ...(ruleTypeIds ? {
      ruleTypeIds
    } : {}),
    ...(consumers ? {
      consumers
    } : {}),
    ...(sortField ? {
      sortField
    } : {}),
    ...(sortOrder ? {
      sortOrder
    } : {}),
    ...(hasReference ? {
      hasReference
    } : {}),
    ...(searchFields ? {
      searchFields: Array.isArray(searchFields) ? searchFields : [searchFields]
    } : {})
  };
};
exports.transformFindRulesInternalBody = transformFindRulesInternalBody;