"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregateRules = aggregateRules;
var _filters = require("../../../../rules_client/common/filters");
var _rule = require("../../../../data/rule");
var _authorization = require("../../../../authorization");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _common = require("../../../../rules_client/common");
var _constants = require("../../../../rules_client/common/constants");
var _schemas = require("./schemas");
var _validation = require("./validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function aggregateRules(context, params) {
  const {
    options = {},
    aggs
  } = params;
  const {
    filter,
    page = 1,
    perPage = 0,
    ruleTypeIds,
    consumers,
    ...restOptions
  } = options;
  let authorizationTuple;
  try {
    authorizationTuple = await context.authorization.getFindAuthorizationFilter({
      authorizationEntity: _authorization.AlertingAuthorizationEntity.Rule,
      filterOpts: _constants.alertingAuthorizationFilterOpts
    });
    (0, _validation.validateRuleAggregationFields)(aggs);
    _schemas.aggregateOptionsSchema.validate(options);
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.AGGREGATE,
      error
    }));
    throw error;
  }
  const {
    filter: authorizationFilter
  } = authorizationTuple;
  const filterKueryNode = (0, _common.buildKueryNodeFilter)(filter);
  const ruleTypeIdsFilter = (0, _filters.buildRuleTypeIdsFilter)(ruleTypeIds);
  const consumersFilter = (0, _filters.buildConsumersFilter)(consumers);
  const combinedFilters = (0, _filters.combineFilters)([filterKueryNode, ruleTypeIdsFilter, consumersFilter], 'and');
  const {
    aggregations
  } = await (0, _rule.findRulesSo)({
    savedObjectsClient: context.unsecuredSavedObjectsClient,
    savedObjectsFindOptions: {
      ...restOptions,
      filter: (0, _filters.combineFilterWithAuthorizationFilter)(combinedFilters, authorizationFilter),
      page,
      perPage,
      aggs
    }
  });
  return aggregations;
}