"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCategoryRequest = createCategoryRequest;
var _is_populated_object = require("@kbn/ml-is-populated-object/src/is_populated_object");
var _create_default_query = require("@kbn/aiops-common/create_default_query");
var _categorization_analyzer = require("./categorization_analyzer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CATEGORY_LIMIT = 1000;
const EXAMPLE_LIMIT = 4;
function createCategoryRequest(index, field, timeField, timeRange, queryIn, runtimeMappings, wrap, intervalMs, additionalFilter, useStandardTokenizer = true, includeSparkline = true, categoryLimit = CATEGORY_LIMIT) {
  const query = (0, _create_default_query.createDefaultQuery)(queryIn, timeField, timeRange);
  const aggs = {
    categories: {
      categorize_text: {
        field,
        size: categoryLimit,
        ...(useStandardTokenizer ? {
          categorization_analyzer: _categorization_analyzer.categorizationAnalyzer
        } : {})
      },
      aggs: {
        examples: {
          top_hits: {
            size: EXAMPLE_LIMIT,
            sort: [timeField],
            _source: field
          }
        },
        ...(intervalMs && includeSparkline ? {
          sparkline: {
            date_histogram: {
              field: timeField,
              fixed_interval: `${intervalMs}ms`
            }
          }
        } : {}),
        ...(additionalFilter ? {
          sub_time_range: {
            date_range: {
              field: timeField,
              format: 'epoch_millis',
              ranges: [{
                from: additionalFilter.from,
                to: additionalFilter.to
              }]
            },
            aggs: {
              examples: {
                top_hits: {
                  size: EXAMPLE_LIMIT,
                  sort: [timeField],
                  _source: field
                }
              },
              ...(intervalMs ? {
                sparkline: {
                  date_histogram: {
                    field: timeField,
                    fixed_interval: `${intervalMs}ms`
                  }
                }
              } : {}),
              ...(additionalFilter.field ? {
                sub_field: {
                  filter: {
                    term: {
                      [additionalFilter.field.name]: additionalFilter.field.value
                    }
                  }
                }
              } : {})
            }
          }
        } : {})
      }
    }
  };
  return {
    params: {
      index,
      body: {
        query,
        aggs: wrap(aggs),
        ...((0, _is_populated_object.isPopulatedObject)(runtimeMappings) ? {
          runtime_mappings: runtimeMappings
        } : {}),
        size: 0
      }
    }
  };
}