"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Plugin {
  constructor(ctx) {
    var _config$email;
    (0, _defineProperty2.default)(this, "allowedEmailDomains", null);
    const config = ctx.config.get();
    this.allowedEmailDomains = ((_config$email = config.email) === null || _config$email === void 0 ? void 0 : _config$email.domain_allowlist) || null;
  }
  setup() {
    return {
      validateEmailAddresses: (emails, options) => (0, _common.validateEmailAddresses)(this.allowedEmailDomains, emails, options)
    };
  }
  start() {}
}
exports.Plugin = Plugin;