"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTabStyles = exports.euiTabContentStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "10tso78-expanded",
  styles: "flex-basis:0%;flex-grow:1;justify-content:center;label:expanded;"
} : {
  name: "10tso78-expanded",
  styles: "flex-basis:0%;flex-grow:1;justify-content:center;label:expanded;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiTabStyles = exports.euiTabStyles = function euiTabStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var selectedUnderlineSize = highContrastMode ? (0, _global_styling.mathWithUnits)(euiTheme.border.thick, function (x) {
    return x * 2;
  }) : euiTheme.border.width.thick;
  return {
    euiTab: /*#__PURE__*/(0, _react.css)("position:relative;display:flex;cursor:pointer;flex-direction:row;align-items:center;gap:", euiTheme.size.s, ";", (0, _global_styling.logicalCSS)('padding-vertical', 0), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.xs), "font-weight:", euiTheme.font.weight.semiBold, ";color:", euiTheme.colors.textHeading, ";&:focus{outline-offset:-", euiTheme.focus.width, ";}&::after{position:absolute;", (0, _global_styling.logicalCSS)('bottom', 0), " ", (0, _global_styling.logicalCSS)('horizontal', 0), " ", (0, _global_styling.logicalCSS)('border-bottom-style', 'solid'), " ", (0, _global_styling.logicalCSS)('border-bottom-width', selectedUnderlineSize), " pointer-events:none;};label:euiTab;"),
    // variations
    expanded: _ref,
    selected: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textPrimary, ";&::after{content:'';border-color:", euiTheme.colors.primary, ";};label:selected;"),
    disabled: {
      disabled: /*#__PURE__*/(0, _react.css)("cursor:not-allowed;color:", euiTheme.colors.textDisabled, ";;label:disabled;"),
      selected: /*#__PURE__*/(0, _react.css)("&::after{content:'';border-color:", euiTheme.colors.textDisabled, ";};label:selected;")
    }
  };
};
var euiTabContentStyles = exports.euiTabContentStyles = function euiTabContentStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiTab__content: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight[euiTheme.font.title.weight], ";;label:euiTab__content;"),
    // sizes
    s: /*#__PURE__*/(0, _react.css)("font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').fontSize, ";line-height:", euiTheme.size.xl, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize, ";line-height:", euiTheme.size.xxl, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 'm').fontSize, ";line-height:", (0, _global_styling.mathWithUnits)([euiTheme.size.xl, euiTheme.size.s], function (x, y) {
      return x + y;
    }), ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)("font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 'l').fontSize, ";line-height:", (0, _global_styling.mathWithUnits)([euiTheme.size.xxxl, euiTheme.size.s], function (x, y) {
      return x + y;
    }), ";;label:xl;")
  };
};