"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.newInternalState = newInternalState;
const chart_types_1 = require("../chart_types");
const chart_state_1 = require("../chart_types/bullet_graph/chart_state");
const internal_chart_state_1 = require("../chart_types/flame_chart/internal_chart_state");
const chart_state_2 = require("../chart_types/goal_chart/state/chart_state");
const chart_state_3 = require("../chart_types/heatmap/state/chart_state");
const chart_state_4 = require("../chart_types/metric/state/chart_state");
const chart_state_5 = require("../chart_types/partition_chart/state/chart_state");
const internal_chart_state_2 = require("../chart_types/timeslip/internal_chart_state");
const chart_state_6 = require("../chart_types/wordcloud/state/chart_state");
const chart_state_7 = require("../chart_types/xy_chart/state/chart_state");
const constructors = {
    [chart_types_1.ChartType.Goal]: () => new chart_state_2.GoalState(),
    [chart_types_1.ChartType.Partition]: () => new chart_state_5.PartitionState(),
    [chart_types_1.ChartType.Flame]: () => new internal_chart_state_1.FlameState(),
    [chart_types_1.ChartType.Timeslip]: () => new internal_chart_state_2.TimeslipState(),
    [chart_types_1.ChartType.XYAxis]: () => new chart_state_7.XYAxisChartState(),
    [chart_types_1.ChartType.Heatmap]: () => new chart_state_3.HeatmapState(),
    [chart_types_1.ChartType.Wordcloud]: () => new chart_state_6.WordcloudState(),
    [chart_types_1.ChartType.Metric]: () => new chart_state_4.MetricState(),
    [chart_types_1.ChartType.Bullet]: () => new chart_state_1.BulletState(),
    [chart_types_1.ChartType.Global]: () => null,
};
function newInternalState(chartType) {
    return chartType ? constructors[chartType]() : null;
}
//# sourceMappingURL=new_internal_state.js.map