"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeslipState = void 0;
const timeslip_chart_1 = require("./timeslip_chart");
const __1 = require("..");
const constants_1 = require("../../common/constants");
const legend_1 = require("../../common/legend");
const get_internal_is_intialized_1 = require("../../state/selectors/get_internal_is_intialized");
const get_legend_items_labels_1 = require("../../state/selectors/get_legend_items_labels");
class TimeslipState {
    chartType = __1.ChartType.Timeslip;
    getChartTypeDescription = () => 'Timeslip chart';
    chartRenderer = timeslip_chart_1.TimeslipWithTooltip;
    eventCallbacks = () => { };
    isInitialized = () => get_internal_is_intialized_1.InitStatus.Initialized;
    isBrushAvailable = () => false;
    isBrushing = () => false;
    isChartEmpty = () => false;
    getLegendItemsLabels = () => get_legend_items_labels_1.EMPTY_LEGEND_ITEM_LIST;
    getLegendItems = () => legend_1.EMPTY_LEGEND_LIST;
    getLegendExtraValues = () => legend_1.EMPTY_LEGEND_ITEM_EXTRA_VALUES;
    getPointerCursor = () => constants_1.DEFAULT_CSS_CURSOR;
    getTooltipAnchor = () => ({ x: 0, y: 0, width: 0, height: 0 });
    isTooltipVisible = () => ({
        visible: false,
        isExternal: false,
        displayOnly: false,
        isPinnable: false,
    });
    getTooltipInfo = () => ({ header: null, values: [] });
    getProjectionContainerArea = () => ({ width: 0, height: 0, top: 0, left: 0 });
    getMainProjectionArea = () => ({ width: 0, height: 0, top: 0, left: 0 });
    getBrushArea = () => null;
    getDebugState = () => ({});
    getSmallMultiplesDomains() {
        return {
            smHDomain: [],
            smVDomain: [],
        };
    }
    canDisplayChartTitles = () => true;
}
exports.TimeslipState = TimeslipState;
//# sourceMappingURL=internal_chart_state.js.map