"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.init = init;
// Hapi is the server used by Kibana
var hapi_1 = require("@hapi/hapi");
var inert_1 = __importDefault(require("@hapi/inert"));
var hapi_pino_1 = __importDefault(require("hapi-pino"));
var os_1 = require("os");
var config_service_1 = require("./config/config_service");
var ui_1 = __importDefault(require("./plugins/ui"));
var routes_1 = __importDefault(require("./plugins/routes"));
function init(params) {
    return __awaiter(this, void 0, void 0, function () {
        var config, logger, tileService, licenseChecker, version, emsDir, server, context, pinoPlugin, uiPlugin, routesPlugin, signals, shutdown, signals_1, signals_1_1, signal;
        var e_1, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    config = params.config, logger = params.logger, tileService = params.tileService, licenseChecker = params.licenseChecker, version = params.version;
                    if (config === undefined) {
                        throw new Error('Configuration undefined');
                    }
                    emsDir = config.appPaths.ems;
                    if (!emsDir) {
                        throw new Error('EMS path not found in settings');
                    }
                    server = getServer(config);
                    context = {
                        config: config,
                        logger: logger,
                        tileService: tileService,
                        licenseChecker: licenseChecker,
                        version: version,
                    };
                    // Bind main context
                    server.bind(context);
                    pinoPlugin = {
                        plugin: hapi_pino_1.default,
                        options: {
                            instance: logger,
                            // Redact Authorization headers, see https://getpino.io/#/docs/redaction
                            redact: ['req.headers.authorization'],
                        },
                    };
                    if (process.env.NODE_ENV !== 'production') {
                        pinoPlugin.options['transport'] = { target: 'pino-pretty' };
                    }
                    uiPlugin = {
                        plugin: ui_1.default,
                        options: {
                            config: config,
                            logger: logger,
                            licenseChecker: licenseChecker,
                        },
                        routes: {},
                    };
                    routesPlugin = {
                        plugin: routes_1.default,
                        options: context,
                        routes: {},
                    };
                    // Attach the basePath to our plugins
                    if (config.basePath !== '' && uiPlugin.routes && routesPlugin.routes) {
                        uiPlugin.routes.prefix = config.basePath;
                        routesPlugin.routes.prefix = config.basePath;
                    }
                    // Static content plugin separately
                    return [4 /*yield*/, server.register(inert_1.default)];
                case 1:
                    // Static content plugin separately
                    _b.sent();
                    // Register the logger and our plugins
                    return [4 /*yield*/, server.register([pinoPlugin, uiPlugin, routesPlugin])];
                case 2:
                    // Register the logger and our plugins
                    _b.sent();
                    return [4 /*yield*/, server.initialize()];
                case 3:
                    _b.sent();
                    server.events.on('stop', function () {
                        if (licenseChecker !== undefined) {
                            logger.debug({
                                message: 'Stopping license check',
                            });
                            licenseChecker.stopChecking();
                            tileService === null || tileService === void 0 ? void 0 : tileService.close();
                        }
                    });
                    server.log(['debug'], "Elastic Maps Server running on ".concat(server.info.uri));
                    signals = ['SIGINT', 'SIGTERM'];
                    shutdown = function (reason) {
                        try {
                            server.stop({ timeout: 100 }).then(function () {
                                console.log("Stopping Elastic Maps Server (".concat(reason, ")"));
                                process.exit(0);
                            }, function () {
                                console.log("Stopping Elastic Maps Server (".concat(reason, ")"));
                                process.exit(1);
                            });
                        }
                        catch (error) {
                            console.error(error.message);
                            process.exit(1);
                        }
                    };
                    try {
                        for (signals_1 = __values(signals), signals_1_1 = signals_1.next(); !signals_1_1.done; signals_1_1 = signals_1.next()) {
                            signal = signals_1_1.value;
                            process.on(signal, function (signal) {
                                shutdown(signal);
                            });
                        }
                    }
                    catch (e_1_1) { e_1 = { error: e_1_1 }; }
                    finally {
                        try {
                            if (signals_1_1 && !signals_1_1.done && (_a = signals_1.return)) _a.call(signals_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                    }
                    process.on('unhandledRejection', function (reason) {
                        if (typeof reason == 'object' || typeof reason == 'string') {
                            shutdown(reason);
                        }
                        else {
                            shutdown('Unknown reason to shutdown');
                        }
                    });
                    return [2 /*return*/, server];
            }
        });
    });
}
function getServer(config) {
    var serverOptions = {
        host: config.host || (0, os_1.hostname)(),
        port: config.port || config_service_1.Constants.HTTP_INTERNAL_PORT,
        debug: false, // must cast type to false
        routes: {
            files: {
                relativeTo: config.appPaths.ems,
            },
            cors: true,
        },
    };
    if (config.ssl.enabled) {
        var ssl = config.ssl;
        return new hapi_1.Server(__assign({ tls: {
                key: ssl.key,
                cert: ssl.certificate,
                passphrase: ssl.keyPassphrase,
                secureOptions: ssl.getSecureOptions(),
                ciphers: ssl.cipherSuites.join(':'),
                honorCipherOrder: true,
            } }, serverOptions));
    }
    else {
        return new hapi_1.Server(serverOptions);
    }
}
//# sourceMappingURL=server.js.map