/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

package org.elasticsearch.xpack.security.metric;

import java.util.Map;

@FunctionalInterface
public interface SecurityMetricAttributesBuilder<C> {

    Map<String, Object> build(C context, String failureReason);

    default Map<String, Object> build(C context) {
        return build(context, null);
    }

}
