/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.plugin;

import javax.inject.Inject;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.plugin.BasePluginBuildPlugin;
import org.elasticsearch.gradle.plugin.GeneratePluginPropertiesTask;
import org.elasticsearch.gradle.plugin.PluginPropertiesExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public class PluginBuildPlugin
implements Plugin<Project> {
    protected final ProviderFactory providerFactory;

    @Inject
    public PluginBuildPlugin(ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(BasePluginBuildPlugin.class);
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add("compileOnly", (Object)("org.elasticsearch:elasticsearch:" + VersionProperties.getElasticsearch()));
        dependencies.add("testImplementation", (Object)("org.elasticsearch.test:framework:" + VersionProperties.getElasticsearch()));
        PluginPropertiesExtension extension = (PluginPropertiesExtension)project.getExtensions().getByType(PluginPropertiesExtension.class);
        project.getTasks().withType(GeneratePluginPropertiesTask.class).named("pluginProperties").configure(task -> {
            task.getIsStable().set((Object)false);
            task.getClassname().set(this.providerFactory.provider(extension::getClassname));
            Provider file = project.getLayout().getBuildDirectory().file("generated-descriptor/plugin-descriptor.properties");
            task.getOutputFile().set(file);
        });
    }
}

