/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.jarhell;

import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.jarhell.JarHellTask;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;

public class JarHellPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        Configuration jarHellConfig = (Configuration)project.getConfigurations().create("jarHell");
        DependencyHandler dependencyHandler = project.getDependencies();
        jarHellConfig.defaultDependencies(deps -> deps.add((Object)dependencyHandler.create((Object)("org.elasticsearch:elasticsearch-core:" + VersionProperties.getElasticsearch()))));
        TaskProvider<? extends Task> jarHellTask = this.createTask(jarHellConfig, project);
        project.getPluginManager().withPlugin("lifecycle-base", p -> project.getTasks().named("check").configure(t -> t.dependsOn(new Object[]{jarHellTask})));
    }

    private TaskProvider<? extends Task> createTask(Configuration jarHellConfig, Project project) {
        TaskProvider jarHell = project.getTasks().register("jarHell", JarHellTask.class);
        project.getPluginManager().withPlugin("java", p -> jarHell.configure(t -> {
            SourceSet testSourceSet = (SourceSet)GradleUtils.getJavaSourceSets(project).findByName("test");
            t.setClasspath(testSourceSet.getRuntimeClasspath());
        }));
        jarHell.configure(t -> t.setJarHellRuntimeClasspath((FileCollection)jarHellConfig));
        return jarHell;
    }
}

